/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.EditableReplicationController;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.kubernetes.AbstractKubernetesDeployer;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;

public class KubernetesAppDeployer
extends AbstractKubernetesDeployer
implements AppDeployer {
    private static final String SERVER_PORT_KEY = "server.port";
    private KubernetesDeployerProperties properties = new KubernetesDeployerProperties();
    private final KubernetesClient client;
    private final ContainerFactory containerFactory;

    @Autowired
    public KubernetesAppDeployer(KubernetesDeployerProperties properties, KubernetesClient client) {
        this(properties, client, new DefaultContainerFactory(properties));
    }

    @Autowired
    public KubernetesAppDeployer(KubernetesDeployerProperties properties, KubernetesClient client, ContainerFactory containerFactory) {
        this.properties = properties;
        this.client = client;
        this.containerFactory = containerFactory;
    }

    public String deploy(AppDeploymentRequest request) {
        String appId = this.createDeploymentId(request);
        Map<String, String> idMap = this.createIdMap(appId, request);
        logger.debug("Deploying app: {}", (Object)appId);
        try {
            AppStatus status = this.status(appId);
            if (!status.getState().equals((Object)DeploymentState.unknown)) {
                throw new IllegalStateException(String.format("App '%s' is already deployed", appId));
            }
            int externalPort = 8080;
            Map parameters = request.getDefinition().getProperties();
            if (parameters.containsKey(SERVER_PORT_KEY)) {
                externalPort = Integer.valueOf((String)parameters.get(SERVER_PORT_KEY));
            }
            logger.debug("Creating service: {} on {}", (Object)appId, (Object)externalPort);
            this.createService(appId, request, idMap, externalPort);
            logger.debug("Creating repl controller: {} on {}", (Object)appId, (Object)externalPort);
            this.createReplicationController(appId, request, idMap, externalPort);
            return appId;
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void undeploy(String appId) {
        logger.debug("Undeploying module: {}", (Object)appId);
        try {
            if ("LoadBalancer".equals(((Service)((ClientResource)this.client.services().withName(appId)).get()).getSpec().getType())) {
                Service svc = (Service)((ClientResource)this.client.services().withName(appId)).get();
                int tries = 0;
                int maxWait = this.properties.getMinutesToWaitForLoadBalancer() * 6;
                while (tries++ < maxWait && svc.getStatus() != null && svc.getStatus().getLoadBalancer() != null && svc.getStatus().getLoadBalancer().getIngress() != null && svc.getStatus().getLoadBalancer().getIngress().isEmpty()) {
                    if (tries % 6 == 0) {
                        logger.warn("Waiting for LoadBalancer to complete before deleting it ...");
                    }
                    logger.debug("Waiting for LoadBalancer, try {}", (Object)tries);
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    svc = (Service)((ClientResource)this.client.services().withName(appId)).get();
                }
                logger.debug("LoadBalancer Ingress: {}", (Object)svc.getStatus().getLoadBalancer().getIngress());
            }
            Boolean svcDeleted = (Boolean)((ClientResource)this.client.services().withName(appId)).delete();
            logger.debug("Deleted service for: {} {}", (Object)appId, (Object)svcDeleted);
            Boolean rcDeleted = (Boolean)((ClientRollableScallableResource)this.client.replicationControllers().withName(appId)).delete();
            logger.debug("Deleted replication controller for: {} {}", (Object)appId, (Object)rcDeleted);
            HashMap<String, String> selector = new HashMap<String, String>();
            selector.put("spring-app-id", appId);
            Boolean podDeleted = (Boolean)((FilterWatchListDeletable)this.client.pods().withLabels(selector)).delete();
            logger.debug("Deleted pods for: {} {}", (Object)appId, (Object)podDeleted);
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public AppStatus status(String appId) {
        HashMap<String, String> selector = new HashMap<String, String>();
        selector.put("spring-app-id", appId);
        PodList list = (PodList)((FilterWatchListDeletable)this.client.pods().withLabels(selector)).list();
        AppStatus status = this.buildAppStatus(this.properties, appId, list);
        logger.debug("Status for app: {} is {}", (Object)appId, (Object)status);
        return status;
    }

    private ReplicationController createReplicationController(String appId, AppDeploymentRequest request, Map<String, String> idMap, int externalPort) {
        String countProperty = (String)request.getDeploymentProperties().get("spring.cloud.deployer.count");
        int count = countProperty != null ? Integer.parseInt(countProperty) : 1;
        EditableReplicationController rc = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName(appId)).withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(count))).withSelector(idMap)).withNewTemplate().withNewMetadata().withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withSpec(this.createPodSpec(appId, request, externalPort))).endTemplate()).endSpec()).build();
        return (ReplicationController)this.client.replicationControllers().create((Object[])new ReplicationController[]{rc});
    }

    private PodSpec createPodSpec(String appId, AppDeploymentRequest request, int port) {
        PodSpecBuilder podSpec = new PodSpecBuilder();
        if (this.properties.getImagePullSecret() != null) {
            podSpec.addNewImagePullSecret(this.properties.getImagePullSecret());
        }
        Container container = this.containerFactory.create(appId, request, port);
        ResourceRequirements req = new ResourceRequirements();
        req.setLimits(this.deduceResourceLimits(this.properties, request));
        container.setResources(req);
        podSpec.addToContainers(new Container[]{container});
        return podSpec.build();
    }

    private void createService(String appId, AppDeploymentRequest request, Map<String, String> idMap, int externalPort) {
        ServiceSpecBuilder spec = new ServiceSpecBuilder();
        boolean isCreateLoadBalancer = false;
        String createLoadBalancer = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.createLoadBalancer");
        if (createLoadBalancer == null) {
            isCreateLoadBalancer = this.properties.isCreateLoadBalancer();
        } else if ("true".equals(createLoadBalancer.toLowerCase())) {
            isCreateLoadBalancer = true;
        }
        if (isCreateLoadBalancer) {
            spec.withType("LoadBalancer");
        }
        ((ServiceSpecFluent.PortsNested)((ServiceSpecBuilder)spec.withSelector(idMap)).addNewPort().withPort(Integer.valueOf(externalPort))).endPort();
        ((DoneableService)((DoneableService)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((DoneableService)((ClientNonNamespaceOperation)this.client.services().inNamespace(this.client.getNamespace())).createNew()).withNewMetadata().withName(appId)).withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withSpec((ServiceSpec)spec.build())).done();
    }
}

