/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.deployer.spi.cloudfoundry.AppNameGenerator;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.util.StringUtils;

public class CloudFoundryAppNameGenerator
implements AppNameGenerator,
InitializingBean {
    private static final Log logger = LogFactory.getLog(CloudFoundryAppNameGenerator.class);
    private static final int MAX_APPNAME_LENGTH = 63;
    private String prefixToUse = "";
    private final CloudFoundryDeploymentProperties properties;

    public CloudFoundryAppNameGenerator(CloudFoundryDeploymentProperties cloudFoundryDeploymentProperties) {
        this.properties = cloudFoundryDeploymentProperties;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.properties.isEnableRandomAppNamePrefix()) {
            this.prefixToUse = this.createUniquePrefix();
            if (!StringUtils.isEmpty((Object)this.properties.getAppNamePrefix())) {
                this.prefixToUse = String.format("%s-%s", this.properties.getAppNamePrefix(), this.prefixToUse);
            }
        } else if (!StringUtils.isEmpty((Object)this.properties.getAppNamePrefix())) {
            this.prefixToUse = this.properties.getAppNamePrefix();
        }
        logger.info((Object)String.format("Prefix to be used for deploying apps: %s", this.prefixToUse));
    }

    @Override
    public String generateAppName(String appName) {
        if (StringUtils.isEmpty((Object)this.prefixToUse)) {
            return appName.substring(0, Math.min(63, appName.length()));
        }
        String string = String.format("%s-%s", this.prefixToUse, appName);
        return string.substring(0, Math.min(63, string.length()));
    }

    private String createUniquePrefix() {
        String alphabet = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        char[] result = new char[7];
        Random random = new Random();
        for (int i = 0; i < result.length; ++i) {
            result[i] = alphabet.charAt(random.nextInt(alphabet.length()));
        }
        return new String(result);
    }
}

