/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.Assert;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum DeploymentStateResource {
    DEPLOYING("deploying", "Deploying", "The stream is being deployed."),
    DEPLOYED("deployed", "Deployed", "The stream has been successfully deployed"),
    UNDEPLOYED("undeployed", "Undeployed", "The app or group is known to the system, but is not currently deployed"),
    PARTIAL("partial", "Partial", "In the case of multiple apps, some have successfully deployed, while others have not"),
    FAILED("failed", "Failed", "All apps have failed deployment"),
    ERROR("error", "Error", "A system error occurred trying to determine deployment status"),
    UNKNOWN("unknown", "Unknown", "The app or group deployment is not known to the system");

    private final String key;
    private final String displayName;
    private final String description;

    private DeploymentStateResource(String key, String displayName, String description) {
        this.key = key;
        this.displayName = displayName;
        this.description = description;
    }

    public static DeploymentStateResource fromKey(String deploymentStateResourceKey) {
        Assert.hasText((String)deploymentStateResourceKey, (String)"Parameter deploymentStateResourceKey must not be null or empty.");
        for (DeploymentStateResource deploymentStateResource : DeploymentStateResource.values()) {
            if (!deploymentStateResource.getKey().equals(deploymentStateResourceKey)) continue;
            return deploymentStateResource;
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }
}

