/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.naming.OperationNotSupportedException;
import org.springframework.cloud.dataflow.rest.client.TaskOperations;
import org.springframework.cloud.dataflow.rest.client.support.VersionUtils;
import org.springframework.cloud.dataflow.rest.resource.CurrentTaskExecutionsResource;
import org.springframework.cloud.dataflow.rest.resource.LaunchResponseResource;
import org.springframework.cloud.dataflow.rest.resource.LauncherResource;
import org.springframework.cloud.dataflow.rest.resource.TaskAppStatusResource;
import org.springframework.cloud.dataflow.rest.resource.TaskDefinitionResource;
import org.springframework.cloud.dataflow.rest.resource.TaskExecutionResource;
import org.springframework.cloud.dataflow.rest.resource.TaskExecutionThinResource;
import org.springframework.cloud.dataflow.rest.resource.TaskExecutionsInfoResource;
import org.springframework.cloud.dataflow.rest.resource.about.AboutResource;
import org.springframework.cloud.dataflow.rest.util.DeploymentPropertiesUtils;
import org.springframework.cloud.dataflow.schema.SchemaVersionTarget;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class TaskTemplate
implements TaskOperations {
    static final String DEFINITIONS_RELATION = "tasks/definitions";
    private static final String DEFINITION_RELATION = "tasks/definitions/definition";
    private static final String EXECUTIONS_CURRENT_RELATION_VERSION = "1.7.0";
    private static final String VALIDATION_RELATION_VERSION = "1.7.0";
    private static final String VALIDATION_THIN_TASK_VERSION = "2.11.3";
    private static final String VALIDATION_TASK_LAUNCH_VERSION = "2.11.0";
    private static final String EXECUTIONS_RELATION = "tasks/executions";
    private static final String THIN_EXECUTIONS_RELATION = "tasks/thinexecutions";
    private static final String EXECUTIONS_CURRENT_RELATION = "tasks/executions/current";
    private static final String EXECUTION_RELATION = "tasks/executions/execution";
    private static final String EXECUTION_LAUNCH_RELATION = "tasks/executions/launch";
    private static final String EXECUTION_RELATION_BY_NAME = "tasks/executions/name";
    private static final String EXECUTIONS_INFO_RELATION = "tasks/info/executions";
    private static final String VALIDATION_REL = "tasks/validation";
    private static final String PLATFORM_LIST_RELATION = "tasks/platforms";
    private static final String RETRIEVE_LOG = "tasks/logs";
    private final RestTemplate restTemplate;
    private final Link definitionsLink;
    private final Link definitionLink;
    private final Link executionsLink;
    private final Link thinExecutionsLink;
    private final Link executionLink;
    private final Link executionLaunchLink;
    private final Link executionByNameLink;
    private final Link executionsCurrentLink;
    private Link executionsInfoLink;
    private final Link validationLink;
    private final Link platformListLink;
    private final String dataFlowServerVersion;
    private String actualDataFlowServerCoreVersion = null;
    private final Link retrieveLogLink;
    private final Link aboutLink;

    TaskTemplate(RestTemplate restTemplate, RepresentationModel<?> resources, String dataFlowServerVersion) {
        Assert.notNull(resources, (String)"URI CollectionModel must not be be null");
        Assert.notNull((Object)restTemplate, (String)"RestTemplate must not be null");
        Assert.notNull((Object)dataFlowServerVersion, (String)"dataFlowVersion must not be null");
        Stream.of("about", DEFINITIONS_RELATION, DEFINITION_RELATION, EXECUTIONS_RELATION, EXECUTION_RELATION, EXECUTION_RELATION_BY_NAME, EXECUTIONS_INFO_RELATION, PLATFORM_LIST_RELATION, RETRIEVE_LOG).forEach(relation -> Assert.isTrue((boolean)resources.getLink(relation).isPresent(), () -> relation + " relation is required"));
        this.restTemplate = restTemplate;
        this.dataFlowServerVersion = dataFlowServerVersion;
        String version = VersionUtils.getThreePartVersion(dataFlowServerVersion);
        if (VersionUtils.isDataFlowServerVersionGreaterThanOrEqualToRequiredVersion(version, "1.7.0")) {
            Assert.isTrue((boolean)resources.getLink(VALIDATION_REL).isPresent(), () -> "tasks/validation relation is required");
            this.validationLink = (Link)resources.getLink(VALIDATION_REL).get();
        } else {
            this.validationLink = null;
        }
        if (VersionUtils.isDataFlowServerVersionGreaterThanOrEqualToRequiredVersion(version, VALIDATION_THIN_TASK_VERSION) && resources.getLink(THIN_EXECUTIONS_RELATION).isPresent()) {
            Assert.isTrue((boolean)resources.getLink(THIN_EXECUTIONS_RELATION).isPresent(), () -> "tasks/thinexecutions relation is required");
            this.thinExecutionsLink = (Link)resources.getLink(THIN_EXECUTIONS_RELATION).get();
        } else {
            this.thinExecutionsLink = null;
        }
        if (VersionUtils.isDataFlowServerVersionGreaterThanOrEqualToRequiredVersion(version, VALIDATION_TASK_LAUNCH_VERSION)) {
            Assert.isTrue((boolean)resources.getLink(EXECUTION_LAUNCH_RELATION).isPresent(), () -> "tasks/executions/launch relation is required");
            this.executionLaunchLink = (Link)resources.getLink(EXECUTION_LAUNCH_RELATION).get();
        } else {
            this.executionLaunchLink = null;
        }
        if (VersionUtils.isDataFlowServerVersionGreaterThanOrEqualToRequiredVersion(version, "1.7.0")) {
            Assert.isTrue((boolean)resources.getLink(EXECUTIONS_CURRENT_RELATION).isPresent(), () -> "tasks/executions/current relation is required");
            this.executionsCurrentLink = (Link)resources.getLink(EXECUTIONS_CURRENT_RELATION).get();
        } else {
            this.executionsCurrentLink = null;
        }
        this.aboutLink = (Link)resources.getLink("about").get();
        this.definitionsLink = (Link)resources.getLink(DEFINITIONS_RELATION).get();
        this.definitionLink = (Link)resources.getLink(DEFINITION_RELATION).get();
        this.executionsLink = (Link)resources.getLink(EXECUTIONS_RELATION).get();
        this.executionLink = (Link)resources.getLink(EXECUTION_RELATION).get();
        this.executionByNameLink = (Link)resources.getLink(EXECUTION_RELATION_BY_NAME).get();
        this.executionsInfoLink = (Link)resources.getLink(EXECUTIONS_INFO_RELATION).get();
        this.platformListLink = (Link)resources.getLink(PLATFORM_LIST_RELATION).get();
        this.retrieveLogLink = (Link)resources.getLink(RETRIEVE_LOG).get();
    }

    public TaskDefinitionResource.Page list() {
        String uriTemplate = this.definitionsLink.getHref();
        uriTemplate = uriTemplate + "?size=2000";
        return (TaskDefinitionResource.Page)this.restTemplate.getForObject(uriTemplate, TaskDefinitionResource.Page.class, new Object[0]);
    }

    public LauncherResource.Page listPlatforms() {
        String uriTemplate = this.platformListLink.getHref();
        uriTemplate = uriTemplate + "?size=2000";
        return (LauncherResource.Page)this.restTemplate.getForObject(uriTemplate, LauncherResource.Page.class, new Object[0]);
    }

    @Override
    public TaskDefinitionResource create(String name, String definition, String description) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        values.add((Object)"name", (Object)name);
        values.add((Object)"definition", (Object)definition);
        values.add((Object)"description", (Object)description);
        return (TaskDefinitionResource)this.restTemplate.postForObject(this.definitionsLink.expand(new Object[0]).getHref(), (Object)values, TaskDefinitionResource.class, new Object[0]);
    }

    private boolean isNewServer() {
        if (this.actualDataFlowServerCoreVersion == null) {
            AboutResource aboutResource = (AboutResource)this.restTemplate.getForObject(this.aboutLink.expand(new Object[0]).getHref(), AboutResource.class, new Object[0]);
            Assert.notNull((Object)aboutResource, (String)"Expected about");
            this.actualDataFlowServerCoreVersion = aboutResource.getVersionInfo().getCore().getVersion();
        }
        String v2_11_0 = VersionUtils.getThreePartVersion("2.11.0-SNAPSHOT");
        String serverVersion = VersionUtils.getThreePartVersion(this.actualDataFlowServerCoreVersion);
        return VersionUtils.isDataFlowServerVersionGreaterThanOrEqualToRequiredVersion(serverVersion, v2_11_0);
    }

    @Override
    public LaunchResponseResource launch(String name, Map<String, String> properties, List<String> arguments) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        String formattedProperties = DeploymentPropertiesUtils.format(properties);
        String commandLineArguments = StringUtils.collectionToDelimitedString(arguments, (String)" ");
        values.add((Object)"properties", (Object)formattedProperties);
        values.add((Object)"arguments", (Object)commandLineArguments);
        if (this.isNewServer()) {
            Assert.notNull((Object)this.executionLaunchLink, (String)"This version of SCDF doesn't support tasks/executions/launch");
            values.add((Object)"name", (Object)name);
            String url = this.executionLaunchLink.expand(new Object[]{name}).getHref();
            values.remove((Object)"name");
            return (LaunchResponseResource)this.restTemplate.postForObject(url, (Object)values, LaunchResponseResource.class, new Object[0]);
        }
        Long id = (Long)this.restTemplate.postForObject(this.executionByNameLink.expand(new Object[]{name}).getHref(), (Object)values, Long.class, new Object[]{name});
        if (id != null) {
            LaunchResponseResource response = new LaunchResponseResource();
            response.setExecutionId(id.longValue());
            response.setSchemaTarget(SchemaVersionTarget.defaultTarget().getName());
            return response;
        }
        throw new RuntimeException("Expected id");
    }

    @Override
    public void stop(String ids, String schemaTarget) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        if (StringUtils.hasText((String)schemaTarget)) {
            values.add((Object)"schemaTarget", (Object)schemaTarget);
        }
        this.restTemplate.postForLocation(this.executionLink.expand(new Object[]{ids}).getHref(), (Object)values, new Object[0]);
    }

    @Override
    public void stop(String ids, String schemaTarget, String platform) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        values.add((Object)"platform", (Object)platform);
        if (StringUtils.hasText((String)schemaTarget)) {
            values.add((Object)"schemaTarget", (Object)schemaTarget);
        }
        this.restTemplate.postForLocation(this.executionLink.expand(new Object[]{ids}).getHref(), (Object)values, new Object[0]);
    }

    @Override
    public void destroy(String name) {
        this.restTemplate.delete(this.definitionLink.expand(new Object[]{name}).getHref(), new Object[0]);
    }

    @Override
    public void destroy(String name, boolean cleanup) {
        String url = cleanup ? this.definitionLink.expand(new Object[]{name}).getHref() + "?cleanup=true" : this.definitionLink.expand(new Object[]{name}).getHref();
        this.restTemplate.delete(url, new Object[0]);
    }

    @Override
    public void destroyAll() {
        this.restTemplate.delete(this.definitionsLink.getHref(), new Object[0]);
    }

    public TaskExecutionResource.Page executionList() {
        return (TaskExecutionResource.Page)this.restTemplate.getForObject(this.executionsLink.getHref(), TaskExecutionResource.Page.class, new Object[0]);
    }

    @Override
    public PagedModel<TaskExecutionThinResource> thinExecutionList() {
        if (this.thinExecutionsLink != null) {
            return (PagedModel)this.restTemplate.getForObject(this.thinExecutionsLink.getHref(), TaskExecutionThinResource.Page.class, new Object[0]);
        }
        return (PagedModel)this.restTemplate.getForObject(this.executionsLink.getHref(), TaskExecutionThinResource.Page.class, new Object[0]);
    }

    public TaskExecutionResource.Page executionListByTaskName(String taskName) {
        return (TaskExecutionResource.Page)this.restTemplate.getForObject(this.executionByNameLink.expand(new Object[]{taskName}).getHref(), TaskExecutionResource.Page.class, new Object[0]);
    }

    @Override
    public TaskExecutionResource taskExecutionStatus(long id, String schemaTarget) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        values.add((Object)"id", (Object)id);
        if (StringUtils.hasText((String)schemaTarget)) {
            values.add((Object)"schemaTarget", (Object)schemaTarget);
        }
        String url = this.executionLink.expand((Map)values).getHref();
        return (TaskExecutionResource)this.restTemplate.getForObject(url, TaskExecutionResource.class, new Object[0]);
    }

    @Override
    public String taskExecutionLog(String externalExecutionId) {
        return this.taskExecutionLog(externalExecutionId, "default");
    }

    @Override
    public String taskExecutionLog(String externalExecutionId, String platform) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskExternalExecutionId", externalExecutionId);
        map.put("platformName", platform);
        return (String)this.restTemplate.getForObject(this.retrieveLogLink.expand(map).getHref(), String.class, new Object[0]);
    }

    @Override
    public Collection<CurrentTaskExecutionsResource> currentTaskExecutions() {
        ParameterizedTypeReference<Collection<CurrentTaskExecutionsResource>> typeReference = new ParameterizedTypeReference<Collection<CurrentTaskExecutionsResource>>(){};
        return (Collection)this.restTemplate.exchange(this.executionsCurrentLink.getHref(), HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, new Object[0]).getBody();
    }

    @Override
    public void cleanup(long id, String schemaTarget) {
        this.cleanup(id, schemaTarget, false);
    }

    @Override
    public void cleanup(long id, String schemaTarget, boolean removeData) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        String uriTemplate = this.executionLink.expand(new Object[]{id}).getHref();
        if (removeData) {
            uriTemplate = uriTemplate + "?action=CLEANUP,REMOVE_DATA";
        }
        if (StringUtils.hasText((String)schemaTarget)) {
            String schemaVal = removeData ? "&schemaTarget=" + schemaTarget : "?schemaTarget=" + schemaTarget;
            uriTemplate = uriTemplate + schemaVal;
        }
        this.restTemplate.delete(uriTemplate, new Object[0]);
    }

    @Override
    public void cleanupAllTaskExecutions(boolean completed, String taskName) {
        String uriTemplate = this.executionsLink.getHref() + "?action=CLEANUP,REMOVE_DATA";
        if (completed) {
            uriTemplate = uriTemplate + "&completed=true";
        }
        if (StringUtils.hasText((String)taskName)) {
            uriTemplate = uriTemplate + "&name=" + taskName;
        }
        this.restTemplate.delete(uriTemplate, new Object[0]);
    }

    @Override
    public Integer getAllTaskExecutionsCount(boolean completed, String taskName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("completed", String.valueOf(completed));
        map.put("name", StringUtils.hasText((String)taskName) ? taskName : "");
        if (this.executionsInfoLink != null) {
            return ((TaskExecutionsInfoResource)Objects.requireNonNull(this.restTemplate.getForObject(this.executionsInfoLink.expand(map).getHref(), TaskExecutionsInfoResource.class, new Object[0]))).getTotalExecutions();
        }
        return 0;
    }

    @Override
    public TaskAppStatusResource validateTaskDefinition(String taskDefinitionName) throws OperationNotSupportedException {
        if (this.validationLink == null) {
            throw new OperationNotSupportedException("Task Validation not supported on Data Flow Server version " + this.dataFlowServerVersion);
        }
        String uriTemplate = this.validationLink.expand(new Object[]{taskDefinitionName}).getHref();
        return (TaskAppStatusResource)this.restTemplate.getForObject(uriTemplate, TaskAppStatusResource.class, new Object[0]);
    }
}

