/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.registry.repository;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.registry.repository.AppRegistrationRepository;
import org.springframework.cloud.dataflow.registry.repository.AppRegistrationRepositoryCustom;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AppRegistrationRepositoryImpl
implements AppRegistrationRepositoryCustom {
    private final EntityManager entityManager;
    @Autowired
    private ObjectProvider<AppRegistrationRepository> appRegistrationRepository;

    public AppRegistrationRepositoryImpl(EntityManager entityManager) {
        Assert.notNull((Object)entityManager, (String)"Entity manager cannot be null");
        this.entityManager = entityManager;
    }

    @Override
    public Page<AppRegistration> findAllByTypeAndNameIsLikeAndVersionAndDefaultVersion(ApplicationType type, String name, String version, boolean defaultVersion, Pageable pageable) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(AppRegistration.class);
        Root appRegistrationRoot = cq.from(AppRegistration.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (type != null) {
            predicates.add(cb.equal((Expression)appRegistrationRoot.get("type"), (Object)type));
        }
        if (StringUtils.hasText((String)name)) {
            predicates.add(cb.like(cb.lower((Expression)appRegistrationRoot.get("name")), "%" + name.toLowerCase() + "%"));
        }
        if (StringUtils.hasText((String)version)) {
            predicates.add(cb.equal(cb.lower((Expression)appRegistrationRoot.get("version")), (Object)version.toLowerCase()));
        }
        if (defaultVersion) {
            predicates.add(cb.isTrue((Expression)appRegistrationRoot.get("defaultVersion")));
        }
        cq.where(predicates.toArray(new Predicate[0]));
        cq.orderBy(QueryUtils.toOrders((Sort)pageable.getSort(), (From)appRegistrationRoot, (CriteriaBuilder)cb));
        TypedQuery query = this.entityManager.createQuery(cq);
        query.setFirstResult((int)pageable.getOffset());
        query.setMaxResults(pageable.getPageSize());
        List resultList = query.getResultList();
        if (defaultVersion) {
            resultList.forEach(appRegistration -> {
                HashSet versions = ((AppRegistrationRepository)this.appRegistrationRepository.getIfAvailable()).findAllByName(appRegistration.getName()).stream().filter(ar -> ar.getType() == appRegistration.getType()).map(AppRegistration::getVersion).collect(Collectors.toCollection(HashSet::new));
                appRegistration.setVersions(versions);
            });
        }
        return new PageImpl(resultList, pageable, this.getTotalCount(cb, predicates.toArray(new Predicate[0])).longValue());
    }

    private Long getTotalCount(CriteriaBuilder criteriaBuilder, Predicate[] predicateArray) {
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root root = criteriaQuery.from(AppRegistration.class);
        criteriaQuery.select((Selection)criteriaBuilder.count((Expression)root));
        criteriaQuery.where(predicateArray);
        return (Long)this.entityManager.createQuery(criteriaQuery).getSingleResult();
    }
}

