/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.registry;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.cloud.deployer.resource.registry.UriRegistry;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

public class RdbmsUriRegistry
implements UriRegistry {
    private static final String TABLE_NAME = "URI_REGISTRY";
    private static final String SELECT_URI_SQL = String.format("select URI from %s where NAME = ?", "URI_REGISTRY");
    private static final String SELECT_ALL_SQL = String.format("select NAME, URI from %s", "URI_REGISTRY");
    private static final String UPDATE_SQL = String.format("update %s set URI=? WHERE NAME=?", "URI_REGISTRY");
    private static final String INSERT_SQL = String.format("insert into %s (NAME, URI) values (?, ?)", "URI_REGISTRY");
    private static final String DELETE_SQL = String.format("delete from %s where NAME=?", "URI_REGISTRY");
    private final JdbcTemplate jdbcTemplate;

    public RdbmsUriRegistry(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"DataSource must not be null");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public URI find(String name) {
        String uriString = null;
        try {
            uriString = (String)this.jdbcTemplate.queryForObject(SELECT_URI_SQL, String.class, new Object[]{name});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        return uriString != null ? this.toUri(uriString) : null;
    }

    public Map<String, URI> findAll() {
        HashMap<String, URI> uriMap = new HashMap<String, URI>();
        List result = this.jdbcTemplate.queryForList(SELECT_ALL_SQL);
        for (Map map : result) {
            uriMap.put(String.valueOf(map.get("NAME")), this.toUri(String.valueOf(map.get("URI"))));
        }
        return uriMap;
    }

    public void register(String name, URI uri) {
        String uriString = uri.toString();
        if (this.find(name) != null) {
            this.jdbcTemplate.update(UPDATE_SQL, new Object[]{uriString, name}, new int[]{12, 12});
        } else {
            this.jdbcTemplate.update(INSERT_SQL, new Object[]{name, uriString}, new int[]{12, 12});
        }
    }

    public void unregister(String name) {
        Assert.hasText((String)name, (String)"name must not be empty nor null");
        this.jdbcTemplate.update(DELETE_SQL, new Object[]{name});
    }

    private URI toUri(String s) {
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }
}

