/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.config.kubernetes;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.dataflow.core.TaskPlatform;
import org.springframework.cloud.dataflow.server.config.features.ConditionalOnTasksEnabled;
import org.springframework.cloud.dataflow.server.config.kubernetes.KubernetesCloudProfileProvider;
import org.springframework.cloud.dataflow.server.config.kubernetes.KubernetesPlatformProperties;
import org.springframework.cloud.dataflow.server.config.kubernetes.KubernetesTaskPlatformFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={KubernetesPlatformProperties.class})
@ConditionalOnTasksEnabled
public class KubernetesTaskPlatformAutoConfiguration {
    @Bean
    public KubernetesTaskPlatformFactory kubernetesTaskPlatformFactory(KubernetesPlatformProperties platformProperties, @Value(value="${spring.cloud.dataflow.features.schedules-enabled:false}") boolean schedulesEnabled) {
        return new KubernetesTaskPlatformFactory(platformProperties, schedulesEnabled);
    }

    @Bean
    public TaskPlatform kubernetesTaskPlatform(KubernetesTaskPlatformFactory kubernetesTaskPlatformFactory, Environment environment) {
        TaskPlatform taskPlatform = kubernetesTaskPlatformFactory.createTaskPlatform();
        KubernetesCloudProfileProvider cloudProfileProvider = new KubernetesCloudProfileProvider();
        if (cloudProfileProvider.isCloudPlatform(environment)) {
            taskPlatform.setPrimary(true);
        }
        return taskPlatform;
    }
}

