/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.config.kubernetes;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.List;
import org.springframework.cloud.dataflow.core.AbstractPlatformProperties;
import org.springframework.cloud.dataflow.core.AbstractTaskPlatformFactory;
import org.springframework.cloud.dataflow.core.Launcher;
import org.springframework.cloud.dataflow.server.config.kubernetes.KubernetesPlatformProperties;
import org.springframework.cloud.dataflow.server.config.kubernetes.KubernetesPlatformTaskLauncherProperties;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesClientFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesScheduler;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesTaskLauncher;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesTaskLauncherProperties;
import org.springframework.cloud.deployer.spi.scheduler.Scheduler;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;

public class KubernetesTaskPlatformFactory
extends AbstractTaskPlatformFactory<KubernetesPlatformProperties> {
    private final KubernetesPlatformTaskLauncherProperties platformTaskLauncherProperties;
    private final boolean schedulesEnabled;

    public KubernetesTaskPlatformFactory(KubernetesPlatformProperties platformProperties, boolean schedulesEnabled, KubernetesPlatformTaskLauncherProperties kubernetesPlatformTaskLauncherProperties) {
        super((AbstractPlatformProperties)platformProperties, "Kubernetes");
        this.schedulesEnabled = schedulesEnabled;
        this.platformTaskLauncherProperties = kubernetesPlatformTaskLauncherProperties;
    }

    public Launcher createLauncher(String account) {
        KubernetesDeployerProperties kubernetesProperties = ((KubernetesPlatformProperties)this.platformProperties).accountExists(account) ? (KubernetesDeployerProperties)((KubernetesPlatformProperties)this.platformProperties).accountProperties(account) : new KubernetesDeployerProperties();
        KubernetesTaskLauncherProperties taskLauncherProperties = this.platformTaskLauncherProperties.accountExists(account) ? (KubernetesTaskLauncherProperties)this.platformTaskLauncherProperties.accountProperties(account) : new KubernetesTaskLauncherProperties();
        DefaultContainerFactory containerFactory = new DefaultContainerFactory(kubernetesProperties);
        KubernetesClient kubernetesClient = KubernetesClientFactory.getKubernetesClient((KubernetesDeployerProperties)kubernetesProperties);
        KubernetesTaskLauncher kubernetesTaskLauncher = new KubernetesTaskLauncher(kubernetesProperties, taskLauncherProperties, kubernetesClient, (ContainerFactory)containerFactory);
        Scheduler scheduler = this.getScheduler(kubernetesProperties, kubernetesClient);
        Launcher launcher = new Launcher(account, "Kubernetes", (TaskLauncher)kubernetesTaskLauncher, scheduler);
        launcher.setDescription(String.format("master url = [%s], namespace = [%s], api version = [%s]", kubernetesClient.getMasterUrl(), kubernetesClient.getNamespace(), kubernetesClient.getApiVersion()));
        return launcher;
    }

    protected List<Launcher> createLaunchers() {
        List launchers = super.createLaunchers();
        for (String account : this.platformTaskLauncherProperties.getAccounts().keySet()) {
            try {
                if (((KubernetesPlatformProperties)this.platformProperties).accountExists(account)) continue;
                launchers.add(this.createLauncher(account));
            }
            catch (Exception e) {
                this.logger.error("{} platform account [{}] could not be registered: {}", new Object[]{this.platformType, account, e});
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return launchers;
    }

    private Scheduler getScheduler(KubernetesDeployerProperties kubernetesDeployerProperties, KubernetesClient kubernetesClient) {
        KubernetesScheduler scheduler = null;
        if (this.schedulesEnabled) {
            scheduler = new KubernetesScheduler(kubernetesClient, kubernetesDeployerProperties);
        }
        return scheduler;
    }
}

