/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.config.cloudfoundry.security.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.common.security.core.support.OAuth2TokenUtilsService;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.security.support.AccessLevel;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.security.support.CloudFoundryAuthorizationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

public class CloudFoundrySecurityService {
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundrySecurityService.class);
    private final OAuth2TokenUtilsService oauth2TokenUtilsService;
    private final RestTemplate restTemplate;
    private final String cloudControllerUrl;
    private final String applicationId;

    public CloudFoundrySecurityService(OAuth2TokenUtilsService oauth2TokenUtilsService, RestTemplate restTemplate, String cloudControllerUrl, String applicationId) {
        Assert.notNull((Object)oauth2TokenUtilsService, (String)"oauth2TokenUtilsService must not be null.");
        Assert.notNull((Object)restTemplate, (String)"restTemplate must not be null.");
        Assert.notNull((Object)cloudControllerUrl, (String)"CloudControllerUrl must not be null.");
        Assert.notNull((Object)applicationId, (String)"ApplicationId must not be null.");
        this.oauth2TokenUtilsService = oauth2TokenUtilsService;
        this.cloudControllerUrl = cloudControllerUrl;
        this.applicationId = applicationId;
        this.restTemplate = restTemplate;
    }

    public boolean isSpaceDeveloper() {
        String accessToken = this.oauth2TokenUtilsService.getAccessTokenOfAuthenticatedUser();
        return this.isSpaceDeveloper(accessToken);
    }

    public boolean isSpaceDeveloper(String accessToken) {
        Assert.hasText((String)accessToken, (String)"The accessToken must not be null or empty.");
        AccessLevel accessLevel = this.getAccessLevel(accessToken, this.applicationId);
        return AccessLevel.FULL.equals((Object)accessLevel);
    }

    public AccessLevel getAccessLevel(String token, String applicationId) throws CloudFoundryAuthorizationException {
        try {
            URI permissionsUri = this.getPermissionsUri(applicationId);
            logger.info("Using PermissionsUri: " + permissionsUri);
            RequestEntity request = RequestEntity.get((URI)permissionsUri).header("Authorization", new String[]{"bearer " + token}).build();
            Map body = (Map)this.restTemplate.exchange(request, Map.class).getBody();
            if (Boolean.TRUE.equals(body.get("read_sensitive_data"))) {
                return AccessLevel.FULL;
            }
            return AccessLevel.RESTRICTED;
        }
        catch (HttpClientErrorException ex) {
            if (ex.getStatusCode().equals((Object)HttpStatus.FORBIDDEN)) {
                return AccessLevel.NONE;
            }
            throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.INVALID_TOKEN, "Invalid token", ex);
        }
        catch (HttpServerErrorException ex) {
            throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.SERVICE_UNAVAILABLE, "Cloud controller not reachable");
        }
    }

    private URI getPermissionsUri(String applicationId) {
        try {
            return new URI(this.cloudControllerUrl + "/v2/apps/" + applicationId + "/permissions");
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

