/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.config.cloudfoundry.security.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.common.security.support.AuthoritiesMapper;
import org.springframework.cloud.common.security.support.CoreSecurityRoles;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.security.support.CloudFoundrySecurityService;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.StringUtils;

public class CloudFoundryDataflowAuthoritiesMapper
implements AuthoritiesMapper {
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundryDataflowAuthoritiesMapper.class);
    private final CloudFoundrySecurityService cloudFoundrySecurityService;

    public CloudFoundryDataflowAuthoritiesMapper(CloudFoundrySecurityService cloudFoundrySecurityService) {
        this.cloudFoundrySecurityService = cloudFoundrySecurityService;
    }

    public Set<GrantedAuthority> mapScopesToAuthorities(String providerId, Set<String> scopes, String token) {
        if (this.cloudFoundrySecurityService.isSpaceDeveloper(token)) {
            ArrayList rolesAsStrings = new ArrayList();
            Set<GrantedAuthority> grantedAuthorities = Stream.of(CoreSecurityRoles.values()).map(roleEnum -> {
                String roleName = "ROLE_" + roleEnum.getKey();
                rolesAsStrings.add(roleName);
                return new SimpleGrantedAuthority(roleName);
            }).collect(Collectors.toSet());
            logger.info("Adding ALL roles {} to Cloud Foundry Space Developer user.", (Object)StringUtils.collectionToCommaDelimitedString(rolesAsStrings));
            return grantedAuthorities;
        }
        return Collections.emptySet();
    }
}

