/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.config.cloudfoundry.security.support;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public enum AccessLevel {
    RESTRICTED("", "/health", "/info"),
    NONE(new String[0]),
    FULL(new String[0]);

    private static final String REQUEST_ATTRIBUTE = "cloudFoundryAccessLevel";
    private final List<String> endpointPaths;

    private AccessLevel(String ... endpointPaths) {
        this.endpointPaths = Arrays.asList(endpointPaths);
    }

    public static AccessLevel get(HttpServletRequest request) {
        return (AccessLevel)((Object)request.getAttribute(REQUEST_ATTRIBUTE));
    }

    public boolean isAccessAllowed(String endpointPath) {
        return this.endpointPaths.isEmpty() || this.endpointPaths.contains(endpointPath);
    }

    public void put(HttpServletRequest request) {
        request.setAttribute(REQUEST_ATTRIBUTE, (Object)this);
    }
}

