/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.config.cloudfoundry.security;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.common.security.core.support.OAuth2TokenUtilsService;
import org.springframework.cloud.common.security.support.AuthoritiesMapper;
import org.springframework.cloud.common.security.support.CustomAuthoritiesOpaqueTokenIntrospector;
import org.springframework.cloud.common.security.support.OnOAuth2SecurityEnabled;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.security.support.CloudFoundryDataflowAuthoritiesMapper;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.security.support.CloudFoundrySecurityService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnCloudPlatform(value=CloudPlatform.CLOUD_FOUNDRY)
@Conditional(value={OnOAuth2SecurityEnabled.class})
@Import(value={CloudFoundryUAAConfiguration.class})
public class CloudFoundryOAuthSecurityConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundryOAuthSecurityConfiguration.class);
    @Autowired
    private CustomAuthoritiesOpaqueTokenIntrospector customAuthoritiesOpaqueTokenIntrospector;
    @Autowired(required=false)
    private CloudFoundryDataflowAuthoritiesMapper cloudFoundryDataflowAuthoritiesExtractor;

    @PostConstruct
    public void init() {
        if (this.cloudFoundryDataflowAuthoritiesExtractor != null) {
            logger.info("Setting up Cloud Foundry AuthoritiesExtractor for UAA.");
            this.customAuthoritiesOpaqueTokenIntrospector.setAuthorityMapper((AuthoritiesMapper)this.cloudFoundryDataflowAuthoritiesExtractor);
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"spring.cloud.dataflow.security.cf-use-uaa"}, havingValue="true")
    public class CloudFoundryUAAConfiguration {
        @Value(value="${vcap.application.cf_api}")
        private String cloudControllerUrl;
        @Value(value="${vcap.application.application_id}")
        private String applicationId;

        @Bean
        public CloudFoundryDataflowAuthoritiesMapper authoritiesExtractor(CloudFoundrySecurityService cloudFoundrySecurityService) {
            return new CloudFoundryDataflowAuthoritiesMapper(cloudFoundrySecurityService);
        }

        @Bean
        public CloudFoundrySecurityService cloudFoundrySecurityService(OAuth2TokenUtilsService oauth2TokenUtilsService, RestTemplate restTemplate) {
            return new CloudFoundrySecurityService(oauth2TokenUtilsService, restTemplate, this.cloudControllerUrl, this.applicationId);
        }
    }
}

