/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.config.cloudfoundry;

import com.github.zafarkhaja.semver.Version;
import io.jsonwebtoken.lang.Assert;
import io.pivotal.scheduler.SchedulerClient;
import java.time.Duration;
import java.util.Optional;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.info.GetInfoRequest;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.DefaultCloudFoundryOperations;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.doppler.ReactorDopplerClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.core.AbstractPlatformProperties;
import org.springframework.cloud.dataflow.core.AbstractTaskPlatformFactory;
import org.springframework.cloud.dataflow.core.Launcher;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformClientProvider;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformConnectionContextProvider;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformProperties;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformTokenProvider;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundrySchedulerClientProvider;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryAppDeployer;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryConnectionProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryPlatformSpecificInfo;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryTaskLauncher;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.scheduler.Scheduler;
import org.springframework.cloud.deployer.spi.scheduler.cloudfoundry.CloudFoundryAppScheduler;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.util.RuntimeVersionUtils;

public class CloudFoundryTaskPlatformFactory
extends AbstractTaskPlatformFactory<CloudFoundryPlatformProperties> {
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundryTaskPlatformFactory.class);
    private final CloudFoundryPlatformTokenProvider platformTokenProvider;
    private final CloudFoundryPlatformConnectionContextProvider connectionContextProvider;
    private final CloudFoundryPlatformClientProvider cloudFoundryClientProvider;
    private final Optional<CloudFoundrySchedulerClientProvider> cloudFoundrySchedulerClientProvider;

    private CloudFoundryTaskPlatformFactory(CloudFoundryPlatformProperties cloudFoundryPlatformProperties, CloudFoundryPlatformTokenProvider platformTokenProvider, CloudFoundryPlatformConnectionContextProvider connectionContextProvider, CloudFoundryPlatformClientProvider cloudFoundryClientProvider, Optional<CloudFoundrySchedulerClientProvider> cloudFoundrySchedulerClientProvider) {
        super((AbstractPlatformProperties)cloudFoundryPlatformProperties, "Cloud Foundry");
        this.platformTokenProvider = platformTokenProvider;
        this.connectionContextProvider = connectionContextProvider;
        this.cloudFoundryClientProvider = cloudFoundryClientProvider;
        this.cloudFoundrySchedulerClientProvider = cloudFoundrySchedulerClientProvider;
    }

    public Launcher createLauncher(String account) {
        this.connectionContext(account);
        this.tokenProvider(account);
        CloudFoundryClient cloudFoundryClient = this.cloudFoundryClient(account);
        CloudFoundryOperations cloudFoundryOperations = this.cloudFoundryOperations(cloudFoundryClient, account);
        CloudFoundryTaskLauncher taskLauncher = new CloudFoundryTaskLauncher(cloudFoundryClient, this.deploymentProperties(account), cloudFoundryOperations, this.runtimeEnvironmentInfo(cloudFoundryClient, account));
        Launcher launcher = new Launcher(account, "Cloud Foundry", (TaskLauncher)taskLauncher, this.scheduler(account, taskLauncher, cloudFoundryOperations));
        CloudFoundryConnectionProperties connectionProperties = this.connectionProperties(account);
        launcher.setDescription(String.format("org = [%s], space = [%s], url = [%s]", connectionProperties.getOrg(), connectionProperties.getSpace(), connectionProperties.getUrl()));
        return launcher;
    }

    private Scheduler scheduler(String account, CloudFoundryTaskLauncher taskLauncher, CloudFoundryOperations cloudFoundryOperations) {
        CloudFoundryAppScheduler scheduler = null;
        if (this.cloudFoundrySchedulerClientProvider.isPresent() && ((CloudFoundryPlatformProperties.CloudFoundryProperties)((CloudFoundryPlatformProperties)this.platformProperties).getAccounts().get(account)).getDeployment().getSchedulerUrl() != null) {
            CloudFoundryDeploymentProperties deploymentProperties = ((CloudFoundryPlatformProperties.CloudFoundryProperties)((CloudFoundryPlatformProperties)this.platformProperties).getAccounts().get(account)).getDeployment();
            CloudFoundrySchedulerClientProvider cloudFoundrySchedulerClientProviderLocal = new CloudFoundrySchedulerClientProvider(this.connectionContextProvider, this.platformTokenProvider, (CloudFoundryPlatformProperties)this.platformProperties);
            SchedulerClient schedulerClient = cloudFoundrySchedulerClientProviderLocal.cloudFoundrySchedulerClient(account);
            scheduler = new CloudFoundryAppScheduler(schedulerClient, cloudFoundryOperations, this.connectionProperties(account), taskLauncher, deploymentProperties);
        }
        return scheduler;
    }

    private ConnectionContext connectionContext(String account) {
        return this.connectionContextProvider.connectionContext(account);
    }

    private TokenProvider tokenProvider(String account) {
        return this.platformTokenProvider.tokenProvider(account);
    }

    private CloudFoundryClient cloudFoundryClient(String account) {
        return this.cloudFoundryClientProvider.cloudFoundryClient(account);
    }

    private CloudFoundryConnectionProperties connectionProperties(String account) {
        return ((CloudFoundryPlatformProperties.CloudFoundryProperties)((CloudFoundryPlatformProperties)this.platformProperties).accountProperties(account)).getConnection();
    }

    private CloudFoundryDeploymentProperties deploymentProperties(String account) {
        return ((CloudFoundryPlatformProperties.CloudFoundryProperties)((CloudFoundryPlatformProperties)this.platformProperties).accountProperties(account)).getDeployment() == null ? new CloudFoundryDeploymentProperties() : ((CloudFoundryPlatformProperties.CloudFoundryProperties)((CloudFoundryPlatformProperties)this.platformProperties).accountProperties(account)).getDeployment();
    }

    private CloudFoundryOperations cloudFoundryOperations(CloudFoundryClient cloudFoundryClient, String account) {
        return DefaultCloudFoundryOperations.builder().cloudFoundryClient(cloudFoundryClient).organization(this.connectionProperties(account).getOrg()).dopplerClient((DopplerClient)ReactorDopplerClient.builder().connectionContext(this.connectionContext(account)).tokenProvider(this.tokenProvider(account)).build()).space(this.connectionProperties(account).getSpace()).build();
    }

    private Version version(CloudFoundryClient cloudFoundryClient, String account) {
        return (Version)cloudFoundryClient.info().get(GetInfoRequest.builder().build()).map(response -> Version.valueOf((String)response.getApiVersion())).doOnNext(versionInfo -> logger.info("Connecting to Cloud Foundry with API Version {}", versionInfo)).timeout(Duration.ofSeconds(this.deploymentProperties(account).getApiTimeout())).block();
    }

    private RuntimeEnvironmentInfo runtimeEnvironmentInfo(CloudFoundryClient cloudFoundryClient, String account) {
        return new CloudFoundryPlatformSpecificInfo(new RuntimeEnvironmentInfo.Builder()).apiEndpoint(this.connectionProperties(account).getUrl().toString()).org(this.connectionProperties(account).getOrg()).space(this.connectionProperties(account).getSpace()).builder().implementationName(CloudFoundryAppDeployer.class.getSimpleName()).spiClass(AppDeployer.class).implementationVersion(RuntimeVersionUtils.getVersion(CloudFoundryAppDeployer.class)).platformType("Cloud Foundry").platformClientVersion(RuntimeVersionUtils.getVersion(cloudFoundryClient.getClass())).platformApiVersion(this.version(cloudFoundryClient, account).toString()).platformHostVersion("unknown").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private CloudFoundryPlatformProperties platformProperties;
        private boolean schedulesEnabled;
        private CloudFoundryDeploymentProperties deploymentProperties;
        private CloudFoundryPlatformTokenProvider platformTokenProvider;
        private CloudFoundryPlatformConnectionContextProvider connectionContextProvider;
        private CloudFoundryPlatformClientProvider cloudFoundryClientProvider;
        private Optional<CloudFoundrySchedulerClientProvider> cloudFoundrySchedulerClientProvider = Optional.empty();

        public Builder platformProperties(CloudFoundryPlatformProperties platformProperties) {
            this.platformProperties = platformProperties;
            return this;
        }

        public Builder schedulesEnabled(boolean schedulesEnabled) {
            this.schedulesEnabled = schedulesEnabled;
            return this;
        }

        public Builder schedulerProperties(CloudFoundryDeploymentProperties deploymentProperties) {
            this.deploymentProperties = deploymentProperties;
            return this;
        }

        public Builder cloudFoundrySchedulerClientProvider(Optional<CloudFoundrySchedulerClientProvider> cloudFoundrySchedulerClientProvider) {
            this.cloudFoundrySchedulerClientProvider = cloudFoundrySchedulerClientProvider;
            return this;
        }

        public Builder platformTokenProvider(CloudFoundryPlatformTokenProvider platformTokenProvider) {
            this.platformTokenProvider = platformTokenProvider;
            return this;
        }

        public Builder connectionContextProvider(CloudFoundryPlatformConnectionContextProvider connectionContextProvider) {
            this.connectionContextProvider = connectionContextProvider;
            return this;
        }

        public Builder cloudFoundryClientProvider(CloudFoundryPlatformClientProvider cloudFoundryClientProvider) {
            this.cloudFoundryClientProvider = cloudFoundryClientProvider;
            return this;
        }

        public CloudFoundryTaskPlatformFactory build() {
            Assert.notNull((Object)((Object)this.platformProperties), (String)"'platformProperties' is required.");
            Assert.notNull((Object)this.platformTokenProvider, (String)"'platformTokenProvider' is required.");
            Assert.notNull((Object)this.connectionContextProvider, (String)"'connectionContextProvider' is required.");
            Assert.notNull((Object)this.cloudFoundryClientProvider, (String)"'cloudFoundryClientProvider' is required.");
            return new CloudFoundryTaskPlatformFactory(this.platformProperties, this.platformTokenProvider, this.connectionContextProvider, this.cloudFoundryClientProvider, this.cloudFoundrySchedulerClientProvider);
        }
    }
}

