/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.config.cloudfoundry;

import java.util.Optional;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.dataflow.core.TaskPlatform;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryCloudProfileProvider;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformClientProvider;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformConnectionContextProvider;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformProperties;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformTokenProvider;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundrySchedulerClientProvider;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryTaskPlatformFactory;
import org.springframework.cloud.dataflow.server.config.features.ConditionalOnTasksEnabled;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnTasksEnabled
@EnableConfigurationProperties(value={CloudFoundryPlatformProperties.class})
public class CloudFoundryTaskPlatformAutoConfiguration {
    @Bean
    public TaskPlatform cloudFoundryPlatform(CloudFoundryTaskPlatformFactory cloudFoundryTaskPlatformFactory, Environment environment) {
        TaskPlatform taskPlatform = cloudFoundryTaskPlatformFactory.createTaskPlatform();
        CloudFoundryCloudProfileProvider cloudProfileProvider = new CloudFoundryCloudProfileProvider();
        if (cloudProfileProvider.isCloudPlatform(environment)) {
            taskPlatform.setPrimary(true);
        }
        return taskPlatform;
    }

    @Bean
    public CloudFoundryPlatformConnectionContextProvider connectionContextProvider(CloudFoundryPlatformProperties cloudFoundryPlatformProperties) {
        return new CloudFoundryPlatformConnectionContextProvider(cloudFoundryPlatformProperties);
    }

    @Bean
    CloudFoundryPlatformTokenProvider platformTokenProvider(CloudFoundryPlatformProperties cloudFoundryPlatformProperties) {
        return new CloudFoundryPlatformTokenProvider(cloudFoundryPlatformProperties);
    }

    @Bean
    public CloudFoundryPlatformClientProvider cloudFoundryClientProvider(CloudFoundryPlatformProperties cloudFoundryPlatformProperties, CloudFoundryPlatformTokenProvider platformTokenProvider, CloudFoundryPlatformConnectionContextProvider connectionContextProvider) {
        return new CloudFoundryPlatformClientProvider(cloudFoundryPlatformProperties, connectionContextProvider, platformTokenProvider);
    }

    @Bean
    public CloudFoundrySchedulerClientProvider schedulerClientProvider(CloudFoundryPlatformConnectionContextProvider connectionContextProvider, CloudFoundryPlatformTokenProvider platformTokenProvider, CloudFoundryPlatformProperties cloudFoundryPlatformProperties) {
        return new CloudFoundrySchedulerClientProvider(connectionContextProvider, platformTokenProvider, cloudFoundryPlatformProperties);
    }

    @Bean
    public CloudFoundryTaskPlatformFactory cloudFoundryTaskPlatformFactory(CloudFoundryPlatformProperties cloudFoundryPlatformProperties, CloudFoundryPlatformTokenProvider platformTokenProvider, CloudFoundryPlatformConnectionContextProvider connectionContextProvider, CloudFoundryPlatformClientProvider cloudFoundryClientProvider, Optional<CloudFoundrySchedulerClientProvider> cloudFoundrySchedulerClientProvider) {
        return CloudFoundryTaskPlatformFactory.builder().platformProperties(cloudFoundryPlatformProperties).platformTokenProvider(platformTokenProvider).connectionContextProvider(connectionContextProvider).cloudFoundryClientProvider(cloudFoundryClientProvider).cloudFoundrySchedulerClientProvider(cloudFoundrySchedulerClientProvider).build();
    }
}

