/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.config.cloudfoundry;

import io.pivotal.reactor.scheduler.ReactorSchedulerClient;
import io.pivotal.scheduler.SchedulerClient;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformConnectionContextProvider;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformProperties;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformTokenProvider;
import reactor.core.publisher.Mono;

public class CloudFoundrySchedulerClientProvider {
    private final CloudFoundryPlatformConnectionContextProvider connectionContextProvider;
    private final CloudFoundryPlatformTokenProvider platformTokenProvider;
    private final CloudFoundryPlatformProperties platformProperties;

    public CloudFoundrySchedulerClientProvider(CloudFoundryPlatformConnectionContextProvider connectionContextProvider, CloudFoundryPlatformTokenProvider platformTokenProvider, CloudFoundryPlatformProperties platformProperties) {
        this.connectionContextProvider = connectionContextProvider;
        this.platformTokenProvider = platformTokenProvider;
        this.platformProperties = platformProperties;
    }

    public SchedulerClient cloudFoundrySchedulerClient(String account) {
        return ReactorSchedulerClient.builder().connectionContext(this.connectionContextProvider.connectionContext(account)).tokenProvider(this.platformTokenProvider.tokenProvider(account)).root(Mono.just((Object)((CloudFoundryPlatformProperties.CloudFoundryProperties)this.platformProperties.getAccounts().get(account)).getDeployment().getSchedulerUrl())).build();
    }
}

