/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.config.cloudfoundry;

import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.tokenprovider.PasswordGrantTokenProvider;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryConnectionProperties;
import org.springframework.util.StringUtils;

public class CloudFoundryPlatformTokenProvider {
    private final CloudFoundryPlatformProperties platformProperties;

    public CloudFoundryPlatformTokenProvider(CloudFoundryPlatformProperties platformProperties) {
        this.platformProperties = platformProperties;
    }

    public TokenProvider tokenProvider(String account) {
        CloudFoundryConnectionProperties connectionProperties = ((CloudFoundryPlatformProperties.CloudFoundryProperties)this.platformProperties.accountProperties(account)).getConnection();
        PasswordGrantTokenProvider.Builder tokenProviderBuilder = PasswordGrantTokenProvider.builder().username(connectionProperties.getUsername()).password(connectionProperties.getPassword()).loginHint(connectionProperties.getLoginHint());
        if (StringUtils.hasText((String)connectionProperties.getClientId())) {
            tokenProviderBuilder.clientId(connectionProperties.getClientId());
        }
        if (StringUtils.hasText((String)connectionProperties.getClientSecret())) {
            tokenProviderBuilder.clientSecret(connectionProperties.getClientSecret());
        }
        return tokenProviderBuilder.build();
    }
}

