/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.config.cloudfoundry;

import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.DefaultConnectionContext;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryConnectionProperties;

public class CloudFoundryPlatformConnectionContextProvider {
    private Map<String, ConnectionContext> connectionContexts = new HashMap<String, ConnectionContext>();
    private final CloudFoundryPlatformProperties platformProperties;

    public CloudFoundryPlatformConnectionContextProvider(CloudFoundryPlatformProperties platformProperties) {
        this.platformProperties = platformProperties;
    }

    public ConnectionContext connectionContext(String account) {
        CloudFoundryConnectionProperties connectionProperties = ((CloudFoundryPlatformProperties.CloudFoundryProperties)this.platformProperties.accountProperties(account)).getConnection();
        this.connectionContexts.putIfAbsent(account, (ConnectionContext)DefaultConnectionContext.builder().apiHost(connectionProperties.getUrl().getHost()).skipSslValidation(connectionProperties.isSkipSslValidation()).build());
        return this.connectionContexts.get(account);
    }
}

