/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.config.cloudfoundry;

import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.reactor.client.ReactorCloudFoundryClient;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformConnectionContextProvider;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformProperties;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryPlatformTokenProvider;

public class CloudFoundryPlatformClientProvider {
    private final CloudFoundryPlatformProperties platformProperties;
    private final CloudFoundryPlatformConnectionContextProvider connectionContextProvider;
    private final CloudFoundryPlatformTokenProvider platformTokenProvider;
    private final Map<String, CloudFoundryClient> cloudFoundryClients = new HashMap<String, CloudFoundryClient>();

    CloudFoundryPlatformClientProvider(CloudFoundryPlatformProperties platformProperties, CloudFoundryPlatformConnectionContextProvider connectionContextProvider, CloudFoundryPlatformTokenProvider platformTokenProvider) {
        this.platformProperties = platformProperties;
        this.connectionContextProvider = connectionContextProvider;
        this.platformTokenProvider = platformTokenProvider;
    }

    public CloudFoundryClient cloudFoundryClient(String account) {
        this.cloudFoundryClients.putIfAbsent(account, (CloudFoundryClient)ReactorCloudFoundryClient.builder().connectionContext(this.connectionContextProvider.connectionContext(account)).tokenProvider(this.platformTokenProvider.tokenProvider(account)).build());
        return this.cloudFoundryClients.get(account);
    }
}

