/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.config.cloudfoundry;

import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.dataflow.server.config.cloudfoundry.CloudFoundryServerConfigurationProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import reactor.core.publisher.Hooks;

@ConditionalOnCloudPlatform(value=CloudPlatform.CLOUD_FOUNDRY)
@Configuration(proxyBeanMethods=false)
public class CloudFoundryDataFlowServerConfiguration {
    private CloudFoundryServerConfigurationProperties cloudFoundryServerConfigurationProperties = new CloudFoundryServerConfigurationProperties();

    @Bean
    @ConfigurationProperties(prefix="spring.cloud.deployer.cloudfoundry.task")
    public CloudFoundryDeploymentProperties taskDeploymentProperties() {
        return new CloudFoundryDeploymentProperties();
    }

    @Bean
    public CloudFoundryServerConfigurationProperties cloudFoundryServerConfigurationProperties() {
        return this.cloudFoundryServerConfigurationProperties;
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void handleContextRefreshedEvent() {
        if (this.cloudFoundryServerConfigurationProperties.isDebugReactor()) {
            Hooks.onOperatorDebug();
        }
    }
}

