/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.container.registry;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.container.registry.ContainerImage;
import org.springframework.cloud.dataflow.container.registry.ContainerImageParser;
import org.springframework.cloud.dataflow.container.registry.ContainerImageRestTemplateFactory;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryConfiguration;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryException;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryRequest;
import org.springframework.cloud.dataflow.container.registry.authorization.RegistryAuthorizer;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class ContainerRegistryService {
    private static final Logger logger = LoggerFactory.getLogger(ContainerRegistryService.class);
    private static final List<String> SUPPORTED_MANIFEST_MEDIA_TYPES = Collections.unmodifiableList(Arrays.asList("application/vnd.oci.image.manifest.v1+json", "application/vnd.docker.distribution.manifest.v2+json"));
    private static final String HTTPS_SCHEME = "https";
    private static final String TAGS_LIST_PATH = "/v2/{repository}/tags/list";
    private static final String TAGS_FIELD = "tags";
    private static final String CATALOG_LIST_PATH = "/v2/_catalog";
    private static final String IMAGE_MANIFEST_REFERENCE_PATH = "v2/{repository}/manifests/{reference}";
    private static final String IMAGE_BLOB_DIGEST_PATH = "v2/{repository}/blobs/{digest}";
    private final ContainerImageRestTemplateFactory containerImageRestTemplateFactory;
    private final ContainerImageParser containerImageParser;
    private final Map<String, ContainerRegistryConfiguration> registryConfigurations;
    private final Map<ContainerRegistryConfiguration.AuthorizationType, RegistryAuthorizer> registryAuthorizerMap;

    public ContainerRegistryService(ContainerImageRestTemplateFactory containerImageRestTemplateFactory, ContainerImageParser containerImageParser, Map<String, ContainerRegistryConfiguration> registryConfigurations, List<RegistryAuthorizer> registryAuthorizers) {
        this.containerImageRestTemplateFactory = containerImageRestTemplateFactory;
        this.containerImageParser = containerImageParser;
        this.registryConfigurations = registryConfigurations;
        this.registryAuthorizerMap = new HashMap<ContainerRegistryConfiguration.AuthorizationType, RegistryAuthorizer>();
        for (RegistryAuthorizer authorizer : registryAuthorizers) {
            this.registryAuthorizerMap.put(authorizer.getType(), authorizer);
        }
    }

    public Map<String, ContainerRegistryConfiguration> getContainerRegistryConfigurations() {
        return this.registryConfigurations;
    }

    public List<String> getTags(String registryName, String repositoryName) {
        try {
            ContainerRegistryConfiguration containerRegistryConfiguration = this.registryConfigurations.get(registryName);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("repository", repositoryName);
            HttpHeaders httpHeaders = new HttpHeaders((MultiValueMap)this.registryAuthorizerMap.get((Object)containerRegistryConfiguration.getAuthorizationType()).getAuthorizationHeaders(containerRegistryConfiguration, properties));
            httpHeaders.set("Accept", "application/json");
            UriComponents manifestUriComponents = UriComponentsBuilder.newInstance().scheme(HTTPS_SCHEME).host(containerRegistryConfiguration.getRegistryHost()).path(TAGS_LIST_PATH).build().expand(new Object[]{repositoryName});
            RestTemplate requestRestTemplate = this.containerImageRestTemplateFactory.getContainerRestTemplate(containerRegistryConfiguration.isDisableSslVerification(), containerRegistryConfiguration.isUseHttpProxy());
            ResponseEntity manifest = requestRestTemplate.exchange(manifestUriComponents.toUri(), HttpMethod.GET, new HttpEntity((MultiValueMap)httpHeaders), Map.class);
            return (List)((Map)manifest.getBody()).get(TAGS_FIELD);
        }
        catch (Exception e) {
            logger.error("Exception getting tag information for the {} from {}", (Object)repositoryName, (Object)registryName);
            return null;
        }
    }

    public Map getRepositories(String registryName) {
        try {
            ContainerRegistryConfiguration containerRegistryConfiguration = this.registryConfigurations.get(registryName);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("repository", registryName);
            HttpHeaders httpHeaders = new HttpHeaders((MultiValueMap)this.registryAuthorizerMap.get((Object)containerRegistryConfiguration.getAuthorizationType()).getAuthorizationHeaders(containerRegistryConfiguration, properties));
            httpHeaders.set("Accept", "application/json");
            UriComponents manifestUriComponents = UriComponentsBuilder.newInstance().scheme(HTTPS_SCHEME).host(containerRegistryConfiguration.getRegistryHost()).path(CATALOG_LIST_PATH).build();
            RestTemplate requestRestTemplate = this.containerImageRestTemplateFactory.getContainerRestTemplate(containerRegistryConfiguration.isDisableSslVerification(), containerRegistryConfiguration.isUseHttpProxy());
            ResponseEntity manifest = requestRestTemplate.exchange(manifestUriComponents.toUri(), HttpMethod.GET, new HttpEntity((MultiValueMap)httpHeaders), Map.class);
            return (Map)manifest.getBody();
        }
        catch (Exception e) {
            logger.error("Exception getting repositories from {}", (Object)registryName);
            return null;
        }
    }

    public ContainerRegistryRequest getRegistryRequest(String imageName) {
        ContainerImage containerImage = this.containerImageParser.parse(imageName);
        ContainerRegistryConfiguration registryConf = this.registryConfigurations.get(containerImage.getRegistryHost());
        if (registryConf == null) {
            throw new ContainerRegistryException("Could not find an Registry Configuration for: " + containerImage.getRegistryHost());
        }
        RegistryAuthorizer registryAuthorizer = this.registryAuthorizerMap.get((Object)registryConf.getAuthorizationType());
        if (registryAuthorizer == null) {
            throw new ContainerRegistryException("Could not find an RegistryAuthorizer of type:" + (Object)((Object)registryConf.getAuthorizationType()));
        }
        HttpHeaders authHttpHeaders = registryAuthorizer.getAuthorizationHeaders(containerImage, registryConf);
        if (authHttpHeaders == null) {
            throw new ContainerRegistryException("Could not obtain authorized headers for: " + containerImage + ", config:" + registryConf);
        }
        RestTemplate requestRestTemplate = this.containerImageRestTemplateFactory.getContainerRestTemplate(registryConf.isDisableSslVerification(), registryConf.isUseHttpProxy());
        return new ContainerRegistryRequest(containerImage, registryConf, authHttpHeaders, requestRestTemplate);
    }

    public <T> T getImageManifest(ContainerRegistryRequest registryRequest, Class<T> responseClassType) {
        String imageManifestMediaType = registryRequest.getRegistryConf().getManifestMediaType();
        if (!SUPPORTED_MANIFEST_MEDIA_TYPES.contains(imageManifestMediaType)) {
            throw new ContainerRegistryException("Not supported image manifest media type:" + imageManifestMediaType);
        }
        HttpHeaders httpHeaders = new HttpHeaders((MultiValueMap)registryRequest.getAuthHttpHeaders());
        httpHeaders.set("Accept", imageManifestMediaType);
        ContainerImage containerImage = registryRequest.getContainerImage();
        UriComponents manifestUriComponents = UriComponentsBuilder.newInstance().scheme(HTTPS_SCHEME).host(containerImage.getHostname()).port(StringUtils.hasText((String)containerImage.getPort()) ? containerImage.getPort() : null).path(IMAGE_MANIFEST_REFERENCE_PATH).build().expand(new Object[]{containerImage.getRepository(), containerImage.getRepositoryReference()});
        ResponseEntity manifest = registryRequest.getRestTemplate().exchange(manifestUriComponents.toUri(), HttpMethod.GET, new HttpEntity((MultiValueMap)httpHeaders), responseClassType);
        return (T)manifest.getBody();
    }

    public <T> T getImageBlob(ContainerRegistryRequest registryRequest, String configDigest, Class<T> responseClassType) {
        ContainerImage containerImage = registryRequest.getContainerImage();
        HttpHeaders httpHeaders = new HttpHeaders((MultiValueMap)registryRequest.getAuthHttpHeaders());
        UriComponents blobUriComponents = UriComponentsBuilder.newInstance().scheme(HTTPS_SCHEME).host(containerImage.getHostname()).port(StringUtils.hasText((String)containerImage.getPort()) ? containerImage.getPort() : null).path(IMAGE_BLOB_DIGEST_PATH).build().expand(new Object[]{containerImage.getRepository(), configDigest});
        ResponseEntity blob = registryRequest.getRestTemplate().exchange(blobUriComponents.toUri(), HttpMethod.GET, new HttpEntity((MultiValueMap)httpHeaders), responseClassType);
        return (T)blob.getBody();
    }
}

