/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.container.registry;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.dataflow.container.registry.ContainerImageParser;
import org.springframework.cloud.dataflow.container.registry.ContainerImageRestTemplateFactory;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryConfiguration;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryProperties;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryService;
import org.springframework.cloud.dataflow.container.registry.authorization.AnonymousRegistryAuthorizer;
import org.springframework.cloud.dataflow.container.registry.authorization.AwsEcrAuthorizer;
import org.springframework.cloud.dataflow.container.registry.authorization.BasicAuthRegistryAuthorizer;
import org.springframework.cloud.dataflow.container.registry.authorization.DockerConfigJsonSecretToRegistryConfigurationConverter;
import org.springframework.cloud.dataflow.container.registry.authorization.DockerOAuth2RegistryAuthorizer;
import org.springframework.cloud.dataflow.container.registry.authorization.RegistryAuthorizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={ContainerRegistryProperties.class})
public class ContainerRegistryAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ContainerRegistryAutoConfiguration.class);

    @Bean
    public RegistryAuthorizer dockerOAuth2RegistryAuthorizer(ContainerImageRestTemplateFactory containerImageRestTemplateFactory) {
        return new DockerOAuth2RegistryAuthorizer(containerImageRestTemplateFactory);
    }

    @Bean
    public RegistryAuthorizer anonymousRegistryAuthorizer() {
        return new AnonymousRegistryAuthorizer();
    }

    @Bean
    public RegistryAuthorizer basicAuthRegistryAuthorizer() {
        return new BasicAuthRegistryAuthorizer();
    }

    @Bean
    public RegistryAuthorizer awsRegistryAuthorizer() {
        return new AwsEcrAuthorizer();
    }

    @Bean
    public ContainerImageParser containerImageParser(ContainerRegistryProperties properties) {
        return new ContainerImageParser(properties.getDefaultRegistryHost(), properties.getDefaultRepositoryTag(), properties.getOfficialRepositoryNamespace());
    }

    @Bean
    @ConditionalOnMissingBean
    public ContainerRegistryService containerRegistryService(ContainerImageRestTemplateFactory containerImageRestTemplateFactory, ContainerImageParser containerImageParser, Map<String, ContainerRegistryConfiguration> registryConfigurationMap, List<RegistryAuthorizer> registryAuthorizers) {
        return new ContainerRegistryService(containerImageRestTemplateFactory, containerImageParser, registryConfigurationMap, registryAuthorizers);
    }

    @Bean
    public Map<String, ContainerRegistryConfiguration> registryConfigurationMap(ContainerRegistryProperties properties, @Value(value="${.dockerconfigjson:#{null}}") String dockerConfigJsonSecret, DockerConfigJsonSecretToRegistryConfigurationConverter secretToRegistryConfigurationConverter) {
        Map<String, ContainerRegistryConfiguration> secretsRegistryConfigurationMap;
        Map<String, ContainerRegistryConfiguration> registryConfigurationMap = properties.getRegistryConfigurations().entrySet().stream().collect(Collectors.toMap(e -> ((ContainerRegistryConfiguration)e.getValue()).getRegistryHost(), Map.Entry::getValue));
        registryConfigurationMap.values().stream().filter(rc -> rc.getAuthorizationType() == ContainerRegistryConfiguration.AuthorizationType.dockeroauth2).filter(rc -> !rc.getExtra().containsKey("registryAuthUri")).forEach(rc -> secretToRegistryConfigurationConverter.getDockerTokenServiceUri(rc.getRegistryHost(), true, rc.isUseHttpProxy()).ifPresent(tokenServiceUri -> rc.getExtra().put("registryAuthUri", (String)tokenServiceUri)));
        if (!StringUtils.isEmpty((Object)dockerConfigJsonSecret) && !CollectionUtils.isEmpty(secretsRegistryConfigurationMap = secretToRegistryConfigurationConverter.convert(dockerConfigJsonSecret))) {
            registryConfigurationMap = Stream.concat(secretsRegistryConfigurationMap.entrySet().stream(), registryConfigurationMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (secretConf, propConf) -> {
                ContainerRegistryConfiguration rc = new ContainerRegistryConfiguration();
                rc.setRegistryHost(secretConf.getRegistryHost());
                rc.setUser(StringUtils.hasText((String)propConf.getUser()) ? propConf.getUser() : secretConf.getUser());
                rc.setSecret(StringUtils.hasText((String)propConf.getSecret()) ? propConf.getSecret() : secretConf.getSecret());
                rc.setAuthorizationType(propConf.getAuthorizationType() != null ? propConf.getAuthorizationType() : secretConf.getAuthorizationType());
                rc.setManifestMediaType(StringUtils.hasText((String)propConf.getManifestMediaType()) ? propConf.getManifestMediaType() : secretConf.getManifestMediaType());
                rc.setDisableSslVerification(propConf.isDisableSslVerification());
                rc.setUseHttpProxy(propConf.isUseHttpProxy());
                rc.getExtra().putAll(secretConf.getExtra());
                rc.getExtra().putAll(propConf.getExtra());
                return rc;
            }));
        }
        logger.debug("Final Registry Configurations: " + registryConfigurationMap);
        return registryConfigurationMap;
    }

    @Bean
    public DockerConfigJsonSecretToRegistryConfigurationConverter secretToRegistryConfigurationConverter(ContainerRegistryProperties properties, ContainerImageRestTemplateFactory containerImageRestTemplate) {
        return new DockerConfigJsonSecretToRegistryConfigurationConverter(properties, containerImageRestTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(name={"containerImageRestTemplateFactory"})
    public ContainerImageRestTemplateFactory containerImageRestTemplateFactory(RestTemplateBuilder builder, ContainerRegistryProperties properties) {
        return new ContainerImageRestTemplateFactory(builder, properties);
    }
}

