/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.container.registry;

import java.util.Arrays;
import org.springframework.cloud.dataflow.container.registry.ContainerImage;
import org.springframework.util.Assert;

public class ContainerImageParser {
    private final String defaultRegistryHost;
    private final String defaultTag;
    private final String officialRepositoryNamespace;
    private static final String LOCALHOST_DOMAIN = "localhost";
    private static final String LEGACY_DEFAULT_DOMAIN = "index.docker.io";
    private static final String PLAIN_DOCKER_IO_DOMAIN = "docker.io";
    private static final String SLASH_SEPARATOR = "/";
    private static final String PORT_SEPARATOR = ":";
    private static final String PERIOD_SEPARATOR = ".";
    private static final String TAG_SEPARATOR = ":";
    private static final String DIGEST_SEPARATOR = "@";

    public ContainerImageParser() {
        this("registry-1.docker.io", "latest", "library");
    }

    public ContainerImageParser(String defaultRegistryHost, String defaultTag, String officialRepoName) {
        this.defaultRegistryHost = defaultRegistryHost;
        this.defaultTag = defaultTag;
        this.officialRepositoryNamespace = officialRepoName;
    }

    public ContainerImage parse(String imageName) {
        String[] pathComponents;
        String repositoryNameAndTag;
        ContainerImage containerImageName = new ContainerImage();
        String[] registryHostAndRemainderSplit = this.splitDockerRegistryHost(imageName);
        String registryHost = registryHostAndRemainderSplit[0];
        String remainder = registryHostAndRemainderSplit[1];
        String[] hostAndPortSplit = registryHost.split(":");
        Assert.isTrue((hostAndPortSplit.length > 0 && hostAndPortSplit.length <= 2 ? 1 : 0) != 0, (String)("Invalid registry host address: " + registryHost));
        containerImageName.setHostname(hostAndPortSplit[0]);
        if (hostAndPortSplit.length == 2) {
            containerImageName.setPort(hostAndPortSplit[1]);
        }
        if ((repositoryNameAndTag = (pathComponents = remainder.split(SLASH_SEPARATOR))[pathComponents.length - 1]).contains(DIGEST_SEPARATOR)) {
            String[] repositoryNameAndDigestSplit = repositoryNameAndTag.split(DIGEST_SEPARATOR);
            Assert.isTrue((repositoryNameAndDigestSplit.length > 0 && repositoryNameAndDigestSplit.length <= 2 ? 1 : 0) != 0, (String)("Invalid repository name: " + repositoryNameAndTag));
            containerImageName.setRepositoryName(repositoryNameAndDigestSplit[0]);
            containerImageName.setRepositoryDigest(repositoryNameAndDigestSplit[1]);
        } else {
            String[] repositoryNameAndTagSplit = repositoryNameAndTag.split(":");
            Assert.isTrue((repositoryNameAndTagSplit.length > 0 && repositoryNameAndTagSplit.length <= 2 ? 1 : 0) != 0, (String)("Invalid repository name: " + repositoryNameAndTag));
            containerImageName.setRepositoryName(repositoryNameAndTagSplit[0]);
            String repositoryTag = repositoryNameAndTagSplit.length == 2 ? repositoryNameAndTagSplit[1] : this.defaultTag;
            containerImageName.setRepositoryTag(repositoryTag);
        }
        if (pathComponents.length >= 2) {
            String[] namespaceComponents = Arrays.copyOf(pathComponents, pathComponents.length - 1);
            containerImageName.setNamespaceComponents(namespaceComponents);
        }
        return containerImageName;
    }

    private String[] splitDockerRegistryHost(String imageName) {
        String remainder;
        String registryHost;
        int i = imageName.indexOf(SLASH_SEPARATOR);
        if (i == -1 || !imageName.substring(0, i).contains(PERIOD_SEPARATOR) && !imageName.substring(0, i).contains(":") && !imageName.substring(0, i).equals(LOCALHOST_DOMAIN)) {
            registryHost = this.defaultRegistryHost;
            remainder = imageName;
        } else {
            registryHost = imageName.substring(0, i);
            remainder = imageName.substring(i + 1);
        }
        if (registryHost.equals(LEGACY_DEFAULT_DOMAIN) || registryHost.equals(PLAIN_DOCKER_IO_DOMAIN)) {
            registryHost = this.defaultRegistryHost;
        }
        if (registryHost.equals(this.defaultRegistryHost) && !remainder.contains(SLASH_SEPARATOR)) {
            remainder = this.officialRepositoryNamespace + SLASH_SEPARATOR + remainder;
        }
        return new String[]{registryHost, remainder};
    }
}

