/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.configuration.metadata.container;

import java.util.Collections;
import java.util.Map;
import org.springframework.cloud.dataflow.configuration.metadata.container.ContainerImageMetadataResolver;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryException;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryRequest;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryService;
import org.springframework.util.StringUtils;

public class DefaultContainerImageMetadataResolver
implements ContainerImageMetadataResolver {
    private final ContainerRegistryService containerRegistryService;

    public DefaultContainerImageMetadataResolver(ContainerRegistryService containerRegistryService) {
        this.containerRegistryService = containerRegistryService;
    }

    @Override
    public Map<String, String> getImageLabels(String imageName) {
        if (!StringUtils.hasText((String)imageName)) {
            throw new ContainerRegistryException("Null or empty image name");
        }
        ContainerRegistryRequest registryRequest = this.containerRegistryService.getRegistryRequest(imageName);
        Map manifest = (Map)this.containerRegistryService.getImageManifest(registryRequest, Map.class);
        if (manifest != null && !this.isNotNullMap(manifest.get("config"))) {
            throw new ContainerRegistryException(String.format("Image [%s] has incorrect or missing manifest config element: %s", imageName, manifest.toString()));
        }
        if (manifest != null) {
            String configDigest = (String)((Map)manifest.get("config")).get("digest");
            if (!StringUtils.hasText((String)configDigest)) {
                throw new ContainerRegistryException(String.format("Missing or invalid Configuration Digest: [%s] for image [%s]", configDigest, imageName));
            }
            Map configBlobMap = (Map)this.containerRegistryService.getImageBlob(registryRequest, configDigest, Map.class);
            if (configBlobMap == null) {
                throw new ContainerRegistryException(String.format("Failed to retrieve configuration json for image [%s] with digest [%s]", imageName, configDigest));
            }
            if (!this.isNotNullMap(configBlobMap.get("config"))) {
                throw new ContainerRegistryException(String.format("Configuration json for image [%s] with digest [%s] has incorrect Config Blog element", imageName, configDigest));
            }
            Map configElement = (Map)configBlobMap.get("config");
            return this.isNotNullMap(configElement.get("Labels")) ? (Map)configElement.get("Labels") : Collections.emptyMap();
        }
        throw new ContainerRegistryException(String.format("Image [%s] is missing manifest", imageName));
    }

    private boolean isNotNullMap(Object object) {
        return object != null && object instanceof Map;
    }
}

