/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.cloud.common.security.core.support.OAuth2AccessTokenProvidingClientHttpRequestInterceptor;
import org.springframework.cloud.dataflow.composedtaskrunner.ComposedTaskRunnerTaskListener;
import org.springframework.cloud.dataflow.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.dataflow.composedtaskrunner.support.ComposedTaskException;
import org.springframework.cloud.dataflow.composedtaskrunner.support.TaskExecutionTimeoutException;
import org.springframework.cloud.dataflow.composedtaskrunner.support.UnexpectedTaskExecutionException;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.DataFlowTemplate;
import org.springframework.cloud.dataflow.rest.client.TaskOperations;
import org.springframework.cloud.dataflow.rest.resource.LaunchResponseResource;
import org.springframework.cloud.dataflow.rest.support.jackson.Jackson2DataflowModule;
import org.springframework.cloud.dataflow.rest.util.HttpClientConfigurer;
import org.springframework.cloud.dataflow.schema.SchemaVersionTarget;
import org.springframework.cloud.task.configuration.TaskProperties;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.core.env.Environment;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class TaskLauncherTasklet
implements Tasklet {
    static final String IGNORE_EXIT_MESSAGE = "IGNORE_EXIT_MESSAGE";
    static final String IGNORE_EXIT_MESSAGE_PROPERTY = "ignore-exit-message";
    private final ComposedTaskProperties composedTaskProperties;
    private final TaskExplorer taskExplorer;
    private Map<String, String> properties;
    private List<String> arguments;
    private final String taskName;
    private static final Logger logger = LoggerFactory.getLogger(TaskLauncherTasklet.class);
    private Long executionId;
    private final String ctrSchemaTarget;
    private long timeout;
    private final ClientRegistrationRepository clientRegistrations;
    private final OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient;
    private TaskOperations taskOperations;
    TaskProperties taskProperties;
    private final ObjectMapper mapper;

    public TaskLauncherTasklet(ClientRegistrationRepository clientRegistrations, OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient, TaskExplorer taskExplorer, ComposedTaskProperties composedTaskProperties, String taskName, TaskProperties taskProperties, Environment environment, @Nullable ObjectMapper mapper) {
        if (mapper == null) {
            mapper = new ObjectMapper();
            mapper.registerModule((Module)new Jdk8Module());
            mapper.registerModule((Module)new Jackson2HalModule());
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.registerModule((Module)new Jackson2DataflowModule());
        }
        this.mapper = mapper;
        Assert.hasText((String)taskName, (String)"taskName must not be empty nor null.");
        Assert.notNull((Object)taskExplorer, (String)"taskExplorer must not be null.");
        Assert.notNull((Object)composedTaskProperties, (String)"composedTaskProperties must not be null");
        this.taskName = taskName;
        this.taskExplorer = taskExplorer;
        this.composedTaskProperties = composedTaskProperties;
        this.taskProperties = taskProperties;
        this.clientRegistrations = clientRegistrations;
        this.clientCredentialsTokenResponseClient = clientCredentialsTokenResponseClient;
        this.ctrSchemaTarget = environment.getProperty("spring.cloud.task.schemaTarget");
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties != null ? properties : new HashMap(0);
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments != null ? arguments : new ArrayList(0);
    }

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) {
        TaskOperations taskOperations = this.taskOperations();
        if (this.executionId == null) {
            Boolean ignoreExitMessage;
            Long parentTaskExecutionId;
            this.timeout = System.currentTimeMillis() + (long)this.composedTaskProperties.getMaxWaitTime();
            logger.debug("Wait time for this task to complete is " + this.composedTaskProperties.getMaxWaitTime());
            logger.debug("Interval check time for this task to complete is " + this.composedTaskProperties.getIntervalTimeBetweenChecks());
            String tmpTaskName = this.taskName.substring(0, this.taskName.lastIndexOf(95));
            ArrayList<String> args = this.arguments;
            ExecutionContext stepExecutionContext = chunkContext.getStepContext().getStepExecution().getExecutionContext();
            if (stepExecutionContext.containsKey("task-arguments")) {
                args = (List)stepExecutionContext.get("task-arguments");
            }
            ArrayList<String> cleansedArgs = new ArrayList<String>();
            if (args != null) {
                for (String argument : args) {
                    if (!argument.startsWith("--spring.cloud.task.parent-execution-id=") && !argument.startsWith("--spring.cloud.task.parent-execution-id%")) {
                        cleansedArgs.add(argument);
                        continue;
                    }
                    logger.debug("cleanse:removing argument:{}", (Object)argument);
                }
                args = cleansedArgs;
            }
            if (args == null) {
                args = new ArrayList<String>();
            }
            if ((parentTaskExecutionId = this.getParentTaskExecutionId(contribution)) != null) {
                args.add("--spring.cloud.task.parent-execution-id=" + parentTaskExecutionId);
                String parentSchemaTarget = StringUtils.hasText((String)this.ctrSchemaTarget) ? this.ctrSchemaTarget : SchemaVersionTarget.defaultTarget().getName();
                args.add("--spring.cloud.task.parent-schema-target=" + parentSchemaTarget);
            } else {
                logger.error("Cannot find task execution id");
            }
            if (StringUtils.hasText((String)this.composedTaskProperties.getPlatformName())) {
                this.properties.put("spring.cloud.dataflow.task.platformName", this.composedTaskProperties.getPlatformName());
            }
            logger.debug("execute:{}:{}:{}", new Object[]{tmpTaskName, this.properties, args});
            LaunchResponseResource response = taskOperations.launch(tmpTaskName, this.properties, args);
            this.executionId = response.getExecutionId();
            stepExecutionContext.put("task-execution-id", (Object)response.getExecutionId());
            stepExecutionContext.put("schema-target", (Object)response.getSchemaTarget());
            stepExecutionContext.put("task-name", (Object)tmpTaskName);
            if (!args.isEmpty()) {
                stepExecutionContext.put("task-arguments", args);
            }
            if ((ignoreExitMessage = this.isIgnoreExitMessage(args, this.properties)) != null) {
                stepExecutionContext.put(IGNORE_EXIT_MESSAGE, (Object)ignoreExitMessage);
            }
        } else {
            try {
                Thread.sleep(this.composedTaskProperties.getIntervalTimeBetweenChecks());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e.getMessage(), e);
            }
            TaskExecution taskExecution = this.taskExplorer.getTaskExecution(this.executionId.longValue());
            if (taskExecution != null && taskExecution.getEndTime() != null) {
                if (taskExecution.getExitCode() == null) {
                    throw new UnexpectedTaskExecutionException("Task returned a null exit code.", taskExecution);
                }
                if (taskExecution.getExitCode() != 0) {
                    throw new UnexpectedTaskExecutionException("Task returned a non zero exit code.", taskExecution);
                }
                return RepeatStatus.FINISHED;
            }
            if (this.composedTaskProperties.getMaxWaitTime() > 0 && System.currentTimeMillis() > this.timeout) {
                throw new TaskExecutionTimeoutException(String.format("Timeout occurred while processing task with Execution Id %s", this.executionId));
            }
        }
        return RepeatStatus.CONTINUABLE;
    }

    public Long getParentTaskExecutionId(StepContribution stepContribution) {
        Long result = null;
        if (this.taskProperties.getExecutionid() != null) {
            result = this.taskProperties.getExecutionid();
            logger.debug("getParentTaskExecutionId:taskProperties.executionId={}", (Object)result);
        } else if (ComposedTaskRunnerTaskListener.getExecutionId() != null) {
            result = ComposedTaskRunnerTaskListener.getExecutionId();
            logger.debug("getParentTaskExecutionId:ComposedTaskRunnerTaskListener.executionId={}", (Object)result);
        } else if (stepContribution != null) {
            result = this.taskExplorer.getTaskExecutionIdByJobExecutionId(stepContribution.getStepExecution().getJobExecutionId().longValue());
        }
        return result;
    }

    public TaskOperations taskOperations() {
        if (this.taskOperations == null) {
            this.taskOperations = this.dataFlowOperations().taskOperations();
            if (this.taskOperations == null) {
                throw new ComposedTaskException("Unable to connect to Data Flow Server to execute task operations. Verify that Data Flow Server's tasks/definitions endpoint can be accessed.");
            }
        }
        return this.taskOperations;
    }

    protected DataFlowOperations dataFlowOperations() {
        RestTemplate restTemplate = DataFlowTemplate.getDefaultDataflowRestTemplate();
        this.validateUsernamePassword(this.composedTaskProperties.getDataflowServerUsername(), this.composedTaskProperties.getDataflowServerPassword());
        HttpClientConfigurer clientHttpRequestFactoryBuilder = null;
        if (this.composedTaskProperties.getOauth2ClientCredentialsClientId() != null || StringUtils.hasText((String)this.composedTaskProperties.getDataflowServerAccessToken()) || StringUtils.hasText((String)this.composedTaskProperties.getDataflowServerUsername()) && StringUtils.hasText((String)this.composedTaskProperties.getDataflowServerPassword())) {
            clientHttpRequestFactoryBuilder = HttpClientConfigurer.create((URI)this.composedTaskProperties.getDataflowServerUri());
        }
        String accessTokenValue = null;
        if (this.composedTaskProperties.getOauth2ClientCredentialsClientId() != null) {
            ClientRegistration clientRegistration = this.clientRegistrations.findByRegistrationId("default");
            OAuth2ClientCredentialsGrantRequest grantRequest = new OAuth2ClientCredentialsGrantRequest(clientRegistration);
            OAuth2AccessTokenResponse res = this.clientCredentialsTokenResponseClient.getTokenResponse((AbstractOAuth2AuthorizationGrantRequest)grantRequest);
            accessTokenValue = res.getAccessToken().getTokenValue();
            logger.debug("Configured OAuth2 Client Credentials for accessing the Data Flow Server");
        } else if (StringUtils.hasText((String)this.composedTaskProperties.getDataflowServerAccessToken())) {
            accessTokenValue = this.composedTaskProperties.getDataflowServerAccessToken();
            logger.debug("Configured OAuth2 Access Token for accessing the Data Flow Server");
        } else if (StringUtils.hasText((String)this.composedTaskProperties.getDataflowServerUsername()) && StringUtils.hasText((String)this.composedTaskProperties.getDataflowServerPassword())) {
            clientHttpRequestFactoryBuilder.basicAuthCredentials(this.composedTaskProperties.getDataflowServerUsername(), this.composedTaskProperties.getDataflowServerPassword());
            logger.debug("Configured basic security for accessing the Data Flow Server");
        } else {
            logger.debug("Not configuring basic security for accessing the Data Flow Server");
        }
        if (accessTokenValue != null) {
            restTemplate.getInterceptors().add(new OAuth2AccessTokenProvidingClientHttpRequestInterceptor(accessTokenValue));
        }
        if (this.composedTaskProperties.isSkipTlsCertificateVerification()) {
            if (clientHttpRequestFactoryBuilder == null) {
                clientHttpRequestFactoryBuilder = HttpClientConfigurer.create((URI)this.composedTaskProperties.getDataflowServerUri());
            }
            clientHttpRequestFactoryBuilder.skipTlsCertificateVerification();
        }
        if (clientHttpRequestFactoryBuilder != null) {
            restTemplate.setRequestFactory(clientHttpRequestFactoryBuilder.buildClientHttpRequestFactory());
        }
        return new DataFlowTemplate(this.composedTaskProperties.getDataflowServerUri(), restTemplate, this.mapper);
    }

    private void validateUsernamePassword(String userName, String password) {
        if (StringUtils.hasText((String)password) && !StringUtils.hasText((String)userName)) {
            throw new IllegalArgumentException("A password may be specified only together with a username");
        }
        if (!StringUtils.hasText((String)password) && StringUtils.hasText((String)userName)) {
            throw new IllegalArgumentException("A username may be specified only together with a password");
        }
    }

    private Boolean isIgnoreExitMessage(List<String> args, Map<String, String> properties) {
        MapConfigurationPropertySource mapConfigurationPropertySource;
        Boolean result = null;
        if (properties != null) {
            mapConfigurationPropertySource = new MapConfigurationPropertySource();
            properties.forEach((key, value) -> {
                key = key.substring(key.lastIndexOf(".") + 1);
                mapConfigurationPropertySource.put(key, value);
            });
            result = this.isIgnoreMessagePresent(mapConfigurationPropertySource);
        }
        if (args != null) {
            mapConfigurationPropertySource = new MapConfigurationPropertySource();
            for (String arg : args) {
                int firstEquals = arg.indexOf(61);
                if (firstEquals == -1) continue;
                mapConfigurationPropertySource.put((Object)arg.substring(0, firstEquals), (Object)arg.substring(firstEquals + 1).trim());
            }
            Boolean argResult = this.isIgnoreMessagePresent(mapConfigurationPropertySource);
            if (argResult != null) {
                result = argResult;
            }
        }
        return result;
    }

    private Boolean isIgnoreMessagePresent(MapConfigurationPropertySource mapConfigurationPropertySource) {
        Binder binder = new Binder(new ConfigurationPropertySource[]{mapConfigurationPropertySource});
        try {
            return (Boolean)binder.bind(IGNORE_EXIT_MESSAGE_PROPERTY, Bindable.of(Boolean.class)).get();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

