/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.dataflow.composedtaskrunner.ComposedTaskRunnerStepFactory;
import org.springframework.cloud.dataflow.composedtaskrunner.RelaxedNames;
import org.springframework.cloud.dataflow.composedtaskrunner.StepBeanDefinitionRegistrar;
import org.springframework.cloud.dataflow.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.dataflow.core.dsl.TaskParser;
import org.springframework.cloud.dataflow.core.dsl.TaskVisitor;
import org.springframework.cloud.dataflow.rest.util.DeploymentPropertiesUtils;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.StringUtils;

public class StepBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(StepBeanDefinitionRegistrar.class);
    private Environment env;
    private boolean firstAdd;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        ComposedTaskProperties properties = this.composedTaskProperties();
        String ctrName = this.env.getProperty("spring.cloud.task.name");
        if (ctrName == null) {
            throw new IllegalStateException("spring.cloud.task.name property must have a value.");
        }
        TaskParser taskParser = new TaskParser("bean-registration", properties.getGraph(), false, true);
        Map taskSuffixMap = this.getTaskApps(taskParser);
        for (String taskName : taskSuffixMap.keySet()) {
            for (int taskSuffix = 0; ((TaskAppNodeHolder)taskSuffixMap.get((Object)taskName)).count >= taskSuffix; ++taskSuffix) {
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ComposedTaskRunnerStepFactory.class);
                builder.addConstructorArgValue((Object)properties);
                builder.addConstructorArgValue((Object)String.format("%s_%s", taskName, taskSuffix));
                builder.addConstructorArgValue((Object)taskName.replaceFirst(ctrName + "-", ""));
                builder.addPropertyValue("taskSpecificProps", (Object)this.getPropertiesForTask(taskName, properties, (TaskAppNodeHolder)taskSuffixMap.get(taskName)));
                String args = this.getCommandLineArgsForTask(properties.getComposedTaskArguments(), taskName, taskSuffixMap, ctrName);
                builder.addPropertyValue("arguments", (Object)args);
                registry.registerBeanDefinition(String.format("%s_%s", taskName, taskSuffix), (BeanDefinition)builder.getBeanDefinition());
            }
        }
    }

    private String getCommandLineArgsForTask(String arguments, String taskName, Map<String, TaskAppNodeHolder> taskSuffixMap, String ctrName) {
        String result = "";
        if (!StringUtils.hasText((String)arguments)) {
            return arguments;
        }
        if (arguments.startsWith("\"") && arguments.endsWith("\"")) {
            arguments = arguments.substring(1, arguments.length() - 1);
        }
        arguments = arguments.replace('\n', ' ').replace('\t', ' ');
        this.firstAdd = true;
        try {
            String[] args = CommandLineUtils.translateCommandline((String)arguments);
            String taskNamePrefix = taskName + ".";
            String taskNameNonIdentify = "--" + taskNamePrefix;
            for (String commandLineArg : Arrays.asList(args)) {
                String userPrefix = this.getPrefix(commandLineArg);
                String commandLineArgPrefix = ctrName + "-" + userPrefix;
                String commandLineArgToken = commandLineArgPrefix + ".";
                if (commandLineArgToken.equals(taskNameNonIdentify) || commandLineArgToken.equals(taskNamePrefix)) {
                    result = this.addBlankToCommandLineArgs(result);
                    if (commandLineArg.startsWith(userPrefix)) {
                        result = result.concat(commandLineArg.substring(userPrefix.length() + 1));
                        continue;
                    }
                    result = result + "--" + commandLineArg.substring(userPrefix.length() + 3);
                    continue;
                }
                if (taskSuffixMap.containsKey(commandLineArgPrefix)) continue;
                result = this.addBlankToCommandLineArgs(result);
                if (commandLineArg.contains(" ")) {
                    commandLineArg = commandLineArg.substring(0, commandLineArg.indexOf("=")) + "=\"" + commandLineArg.substring(commandLineArg.indexOf("=") + 1) + "\"";
                }
                result = result.concat(commandLineArg);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to extract command line args for task " + taskName, e);
        }
        return result;
    }

    private String addBlankToCommandLineArgs(String commandArgs) {
        String result = commandArgs;
        if (this.firstAdd) {
            this.firstAdd = false;
        } else {
            result = result.concat(" ");
        }
        return result;
    }

    private String getPrefix(String commandLineArg) {
        String commandLineArgPrefix = !commandLineArg.contains("=") ? commandLineArg : commandLineArg.substring(0, commandLineArg.indexOf("="));
        int indexOfSeparator = commandLineArgPrefix.indexOf(".");
        if (indexOfSeparator > -1) {
            commandLineArgPrefix = commandLineArg.substring(0, indexOfSeparator);
        }
        if (commandLineArgPrefix.startsWith("--")) {
            commandLineArgPrefix = commandLineArgPrefix.substring(2);
        }
        return commandLineArgPrefix;
    }

    private Map<String, String> getPropertiesForTask(String taskName, ComposedTaskProperties properties, TaskAppNodeHolder holder) {
        Map taskDeploymentProperties = DeploymentPropertiesUtils.parse((String)properties.getComposedTaskProperties());
        HashMap<String, String> deploymentProperties = new HashMap<String, String>();
        this.updateDeploymentProperties(String.format("app.%s.", taskName), taskDeploymentProperties, deploymentProperties);
        this.updateDeploymentProperties(String.format("deployer.%s.", taskName), taskDeploymentProperties, deploymentProperties);
        String subTaskName = taskName.substring(taskName.indexOf(45) + 1);
        this.updateVersionDeploymentProperties(taskName, subTaskName, taskDeploymentProperties, deploymentProperties);
        return deploymentProperties;
    }

    private void updateDeploymentProperties(String prefix, Map<String, String> taskDeploymentProperties, Map<String, String> deploymentProperties) {
        for (Map.Entry<String, String> entry : taskDeploymentProperties.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            deploymentProperties.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
    }

    private void updateVersionDeploymentProperties(String taskName, String subTaskName, Map<String, String> taskDeploymentProperties, Map<String, String> deploymentProperties) {
        String prefix = String.format("version.%s", taskName);
        String key = String.format("version.%s", subTaskName);
        for (Map.Entry<String, String> entry : taskDeploymentProperties.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            String realkey = String.format("version%s", entry.getKey().replaceFirst("^" + prefix, ""));
            log.debug("updateVersionDeploymentProperties {} {} {}", new Object[]{key, entry.getValue(), realkey});
            deploymentProperties.put(realkey, entry.getValue());
        }
    }

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }

    private ComposedTaskProperties composedTaskProperties() {
        String intervalTimeBetweenChecks;
        String maxWaitTime;
        String dataFlowUriString;
        ComposedTaskProperties properties = new ComposedTaskProperties();
        String skipTlsCertificateVerification = this.getPropertyValue("skip-tls-certificate-verification");
        if (skipTlsCertificateVerification != null) {
            properties.setSkipTlsCertificateVerification(Boolean.parseBoolean(skipTlsCertificateVerification));
        }
        if ((dataFlowUriString = this.getPropertyValue("dataflow-server-uri")) != null) {
            properties.setDataflowServerUri(URI.create(dataFlowUriString));
        }
        if ((maxWaitTime = this.getPropertyValue("max-wait-time")) != null) {
            properties.setMaxWaitTime(Integer.parseInt(maxWaitTime));
        }
        if ((intervalTimeBetweenChecks = this.getPropertyValue("interval-time-between-checks")) != null) {
            properties.setIntervalTimeBetweenChecks(Integer.parseInt(intervalTimeBetweenChecks));
        }
        properties.setGraph(this.getPropertyValue("graph"));
        properties.setComposedTaskArguments(this.getPropertyValue("composed-task-arguments"));
        properties.setPlatformName(this.getPropertyValue("platform-name"));
        properties.setComposedTaskProperties(this.getPropertyValue("composed-task-properties"));
        properties.setDataflowServerAccessToken(this.getPropertyValue("dataflow-server-access-token"));
        properties.setDataflowServerPassword(this.getPropertyValue("dataflow-server-password"));
        properties.setDataflowServerUsername(this.getPropertyValue("dataflow-server-username"));
        properties.setOauth2ClientCredentialsClientId(this.getPropertyValue("oauth2-client-credentials-client-id"));
        properties.setOauth2ClientCredentialsClientSecret(this.getPropertyValue("oauth2-client-credential-client-secret"));
        String oauth2ClientCredentialsClientAuthenticationMethodAsString = this.getPropertyValue("oauth2-client-credential-client-authentication-method");
        if (oauth2ClientCredentialsClientAuthenticationMethodAsString != null) {
            properties.setOauth2ClientCredentialsClientAuthenticationMethod(new ClientAuthenticationMethod(oauth2ClientCredentialsClientAuthenticationMethodAsString));
        }
        properties.setOauth2ClientCredentialsScopes(StringUtils.commaDelimitedListToSet((String)this.getPropertyValue("oauth2-client-credentials-scopes")));
        return properties;
    }

    private Map<String, TaskAppNodeHolder> getTaskApps(TaskParser taskParser) {
        TaskAppsMapCollector collector = new TaskAppsMapCollector();
        taskParser.parse().accept((TaskVisitor)collector);
        return collector.getTaskApps();
    }

    private String getPropertyValue(String key) {
        RelaxedNames relaxedNames = new RelaxedNames(key);
        String result = null;
        for (String relaxedName : relaxedNames) {
            if (!this.env.containsProperty(relaxedName)) continue;
            result = this.env.getProperty(relaxedName);
            break;
        }
        return result;
    }
}

