/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.support.JobRepositoryFactoryBean;
import org.springframework.batch.item.database.support.DataFieldMaxValueIncrementerFactory;
import org.springframework.boot.autoconfigure.batch.BasicBatchConfigurer;
import org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.cloud.dataflow.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.dataflow.composedtaskrunner.support.ComposedTaskException;
import org.springframework.cloud.dataflow.core.database.support.MultiSchemaIncrementerFactory;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class ComposedBatchConfigurer
extends BasicBatchConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(ComposedBatchConfigurer.class);
    private DataSource incrementerDataSource;
    private Map<String, DataFieldMaxValueIncrementer> incrementerMap;
    private ComposedTaskProperties composedTaskProperties;

    protected ComposedBatchConfigurer(BatchProperties properties, DataSource dataSource, TransactionManagerCustomizers transactionManagerCustomizers, ComposedTaskProperties composedTaskProperties) {
        super(properties, dataSource, transactionManagerCustomizers);
        this.incrementerDataSource = dataSource;
        this.incrementerMap = new HashMap();
        this.composedTaskProperties = composedTaskProperties;
    }

    protected JobRepository createJobRepository() {
        return this.getJobRepository();
    }

    public JobRepository getJobRepository() {
        JobRepositoryFactoryBean factory = new JobRepositoryFactoryBean();
        MultiSchemaIncrementerFactory incrementerFactory = new MultiSchemaIncrementerFactory(this.incrementerDataSource);
        factory.setIncrementerFactory((DataFieldMaxValueIncrementerFactory)incrementerFactory);
        factory.setDataSource(this.incrementerDataSource);
        factory.setTransactionManager(this.getTransactionManager());
        factory.setIsolationLevelForCreate(this.composedTaskProperties.getTransactionIsolationLevel());
        try {
            factory.afterPropertiesSet();
            return factory.getObject();
        }
        catch (Exception exception) {
            throw new ComposedTaskException(exception.getMessage());
        }
    }
}

