/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.ExpansionStrategy;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinitionService;
import org.springframework.cloud.dataflow.core.StreamDefinitionServiceUtils;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;

public class PipeIntoOtherAppsExpansionStrategy
implements ExpansionStrategy {
    private final AppRegistryService appRegistry;
    private final StreamDefinitionService streamDefinitionService;

    public PipeIntoOtherAppsExpansionStrategy(AppRegistryService appRegistry, StreamDefinitionService streamDefinitionService) {
        this.appRegistry = appRegistry;
        this.streamDefinitionService = streamDefinitionService;
    }

    @Override
    public boolean addProposals(String text, StreamDefinition streamDefinition, int detailLevel, List<CompletionProposal> collector) {
        boolean couldBeASink;
        if (text.isEmpty() || !text.endsWith(" ")) {
            return false;
        }
        LinkedList streamAppDefinitions = this.streamDefinitionService.getAppDefinitions(streamDefinition);
        StreamAppDefinition lastApp = (StreamAppDefinition)StreamDefinitionServiceUtils.getDeploymentOrderIterator((LinkedList)streamAppDefinitions).next();
        boolean bl = couldBeASink = this.appRegistry.find(lastApp.getName(), ApplicationType.sink) != null;
        if (couldBeASink) {
            boolean couldBeAProcessor;
            boolean bl2 = couldBeAProcessor = this.appRegistry.find(lastApp.getName(), ApplicationType.processor) != null;
            if (!couldBeAProcessor) {
                return false;
            }
        }
        CompletionProposal.Factory proposals = CompletionProposal.expanding(text);
        for (AppRegistration appRegistration : this.appRegistry.findAll()) {
            if (appRegistration.getType() != ApplicationType.processor && appRegistration.getType() != ApplicationType.sink) continue;
            String expansion = CompletionUtils.maybeQualifyWithLabel(appRegistration.getName(), streamAppDefinitions);
            collector.add(proposals.withSeparateTokens("| " + expansion, "Continue stream definition with a " + appRegistration.getType()));
        }
        return false;
    }
}

