/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.common.flyway;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.common.flyway.SuppressDataAccessException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.util.Assert;

public class SuppressSQLErrorCodesTranslator
extends SQLErrorCodeSQLExceptionTranslator {
    private static final Logger logger = LoggerFactory.getLogger(SuppressSQLErrorCodesTranslator.class);
    private final List<Integer> errorCodes;

    public SuppressSQLErrorCodesTranslator(int errorCode) {
        this(Arrays.asList(errorCode));
    }

    public SuppressSQLErrorCodesTranslator(List<Integer> errorCodes) {
        Assert.notNull(errorCodes, (String)"errorCodes must be set");
        this.errorCodes = errorCodes;
    }

    protected DataAccessException customTranslate(String task, String sql, SQLException sqlEx) {
        logger.debug("Checking sql error code {} against {}", (Object)sqlEx.getErrorCode(), this.errorCodes);
        if (this.errorCodes.contains(sqlEx.getErrorCode())) {
            return new SuppressDataAccessException(task, sqlEx);
        }
        return super.customTranslate(task, sql, sqlEx);
    }
}

