/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.common.flyway;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;

public class SqlCommand {
    private final String command;
    private final List<Integer> suppressedErrorCodes;

    public static SqlCommand from(String command) {
        return new SqlCommand(command, null);
    }

    public static SqlCommand from(String command, int suppressedErrorCode) {
        return new SqlCommand(command, suppressedErrorCode);
    }

    public SqlCommand() {
        this(null, null);
    }

    public SqlCommand(String command, int suppressedErrorCode) {
        this(command, Collections.singletonList(suppressedErrorCode));
    }

    public SqlCommand(String command, List<Integer> suppressedErrorCodes) {
        this.command = command;
        this.suppressedErrorCodes = suppressedErrorCodes;
    }

    public String getCommand() {
        return this.command;
    }

    public List<Integer> getSuppressedErrorCodes() {
        return this.suppressedErrorCodes;
    }

    public boolean canHandleInJdbcTemplate() {
        return false;
    }

    public void handle(JdbcTemplate jdbcTemplate, Connection connection) {
        throw new UnsupportedOperationException("Not supported in a base class");
    }
}

