/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.common.flyway;

import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

public final class DatabaseDriverUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseDriverUtils.class);

    private DatabaseDriverUtils() {
    }

    public static DatabaseDriver getDatabaseDriver(DataSource dataSource) {
        try {
            String url = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, DatabaseMetaData::getURL);
            DatabaseDriver databaseDriver = DatabaseDriver.fromJdbcUrl((String)url);
            if (databaseDriver == DatabaseDriver.MARIADB) {
                String product = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, DatabaseMetaData::getDatabaseProductName);
                if (DatabaseDriver.MYSQL.name().equalsIgnoreCase(product)) {
                    LOG.info("Using MariaDB driver against MySQL database - will use MySQL");
                    databaseDriver = DatabaseDriver.MYSQL;
                }
            }
            return databaseDriver;
        }
        catch (MetaDataAccessException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

