/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.autoconfigure.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.cloud.dataflow.server.config.CloudProfileProvider;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class ProfileApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    public static final String IGNORE_PROFILEAPPLICATIONLISTENER_PROPERTY_NAME = "spring.cloud.dataflow.server.profileapplicationlistener.ignore";
    public static final String IGNORE_PROFILEAPPLICATIONLISTENER_ENVVAR_NAME = "SPRING_CLOUD_DATAFLOW_SERVER_PROFILEAPPLICATIONLISTENER_IGNORE";
    private static final Logger logger = LoggerFactory.getLogger(ProfileApplicationListener.class);
    private ConfigurableEnvironment environment;

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        this.environment = event.getEnvironment();
        ServiceLoader<CloudProfileProvider> cloudProfileProviders = ServiceLoader.load(CloudProfileProvider.class);
        if (this.ignoreFromSystemProperty() || this.ignoreFromEnvironmentVariable() || this.cloudProfilesAlreadySet(cloudProfileProviders)) {
            return;
        }
        boolean addedCloudProfile = false;
        boolean addedKubernetesProfile = false;
        for (CloudProfileProvider cloudProfileProvider : cloudProfileProviders) {
            if (!cloudProfileProvider.isCloudPlatform((Environment)this.environment)) continue;
            String profileToAdd = cloudProfileProvider.getCloudProfile();
            if (Arrays.asList(this.environment.getActiveProfiles()).contains(profileToAdd)) continue;
            if (profileToAdd.equals("kubernetes")) {
                addedKubernetesProfile = true;
            }
            this.environment.addActiveProfile(profileToAdd);
            addedCloudProfile = true;
        }
        if (!addedKubernetesProfile) {
            LinkedHashMap<String, Boolean> properties = new LinkedHashMap<String, Boolean>();
            properties.put("spring.cloud.kubernetes.enabled", false);
            logger.info("Setting property 'spring.cloud.kubernetes.enabled' to false.");
            MutablePropertySources propertySources = this.environment.getPropertySources();
            if (propertySources != null) {
                if (propertySources.contains("commandLineArgs")) {
                    propertySources.addAfter("commandLineArgs", (PropertySource)new MapPropertySource("skipperProfileApplicationListener", properties));
                } else {
                    propertySources.addFirst((PropertySource)new MapPropertySource("skipperProfileApplicationListener", properties));
                }
            }
        }
        if (!addedCloudProfile) {
            this.environment.addActiveProfile("local");
        }
    }

    private boolean ignoreFromSystemProperty() {
        return Boolean.getBoolean(IGNORE_PROFILEAPPLICATIONLISTENER_PROPERTY_NAME);
    }

    private boolean ignoreFromEnvironmentVariable() {
        return Boolean.parseBoolean(System.getenv(IGNORE_PROFILEAPPLICATIONLISTENER_ENVVAR_NAME));
    }

    public int getOrder() {
        return 0;
    }

    private boolean cloudProfilesAlreadySet(Iterable<CloudProfileProvider> cloudProfileProviders) {
        ArrayList<String> cloudProfileNames = new ArrayList<String>();
        for (CloudProfileProvider cloudProfileProvider : cloudProfileProviders) {
            cloudProfileNames.add(cloudProfileProvider.getCloudProfile());
        }
        boolean cloudProfilesAlreadySet = false;
        for (String cloudProfileName : cloudProfileNames) {
            if (!Arrays.asList(this.environment.getActiveProfiles()).contains(cloudProfileName)) continue;
            cloudProfilesAlreadySet = true;
        }
        return cloudProfilesAlreadySet;
    }
}

