/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.autoconfigure.local;

import java.util.Collections;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.dataflow.server.config.OnLocalPlatform;
import org.springframework.cloud.dataflow.server.config.features.SchedulerConfiguration;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleInfo;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleRequest;
import org.springframework.cloud.deployer.spi.scheduler.Scheduler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={OnLocalPlatform.class, SchedulerConfiguration.SchedulerConfigurationPropertyChecker.class})
public class LocalSchedulerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Scheduler localScheduler() {
        return new Scheduler(){

            public void schedule(ScheduleRequest scheduleRequest) {
                throw new UnsupportedOperationException("Scheduling is not implemented for local platform.");
            }

            public void unschedule(String scheduleName) {
                throw new UnsupportedOperationException("Scheduling is not implemented for local platform.");
            }

            public List<ScheduleInfo> list(String taskDefinitionName) {
                return Collections.emptyList();
            }

            public List<ScheduleInfo> list() {
                return Collections.emptyList();
            }
        };
    }
}

