/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock.restdocs;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.snippet.PlaceholderResolverFactory;
import org.springframework.restdocs.snippet.RestDocumentationContextPlaceholderResolverFactory;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.restdocs.snippet.StandardWriterResolver;
import org.springframework.restdocs.templates.TemplateFormat;
import org.springframework.util.StringUtils;

public class WireMockSnippet
implements Snippet {
    private static final TemplateFormat TEMPLATE_FORMAT = new TemplateFormat(){

        public String getId() {
            return "json";
        }

        public String getFileExtension() {
            return "json";
        }
    };
    private String snippetName = "stubs";
    private Set<String> headerBlackList = new HashSet<String>(Arrays.asList("host", "content-length"));
    private Set<String> jsonPaths = new LinkedHashSet<String>();
    private MediaType contentType;
    private StubMapping stubMapping;
    private boolean hasJsonBodyRequestToMatch = false;
    private boolean hasXmlBodyRequestToMatch = false;

    public void document(Operation operation) throws IOException {
        this.extractMatchers(operation);
        if (this.stubMapping == null) {
            this.stubMapping = this.request(operation).willReturn(this.response(operation)).build();
        }
        String json = Json.write((Object)this.stubMapping);
        RestDocumentationContext context = (RestDocumentationContext)operation.getAttributes().get(RestDocumentationContext.class.getName());
        RestDocumentationContextPlaceholderResolverFactory placeholders = new RestDocumentationContextPlaceholderResolverFactory();
        StandardWriterResolver writerResolver = new StandardWriterResolver((PlaceholderResolverFactory)placeholders, "UTF-8", TEMPLATE_FORMAT);
        try (Writer writer = writerResolver.resolve(this.snippetName, operation.getName(), context);){
            writer.append(json);
        }
    }

    private void extractMatchers(Operation operation) {
        Set jsonPaths;
        this.stubMapping = (StubMapping)operation.getAttributes().get("contract.stubMapping");
        if (this.stubMapping != null) {
            return;
        }
        this.jsonPaths = jsonPaths = (Set)operation.getAttributes().get("contract.jsonPaths");
        this.contentType = (MediaType)operation.getAttributes().get("contract.contentType");
        if (this.contentType == null) {
            this.hasJsonBodyRequestToMatch = this.hasJsonContentType(operation);
            this.hasXmlBodyRequestToMatch = this.hasXmlContentType(operation);
        }
    }

    private boolean hasJsonContentType(Operation operation) {
        return this.hasContentType(operation, MediaType.APPLICATION_JSON);
    }

    private boolean hasXmlContentType(Operation operation) {
        return this.hasContentType(operation, MediaType.APPLICATION_XML);
    }

    private boolean hasContentType(Operation operation, MediaType mediaType) {
        return operation.getRequest().getHeaders().getContentType() != null && operation.getRequest().getHeaders().getContentType().isCompatibleWith(mediaType);
    }

    private ResponseDefinitionBuilder response(Operation operation) {
        String content = operation.getResponse().getContentAsString();
        ResponseDefinitionBuilder response = WireMock.aResponse().withHeaders(this.responseHeaders(operation)).withBody(content);
        if (content != null && content.contains("localhost:{{request.requestLine.port}}")) {
            response = response.withTransformers(new String[]{"response-template"});
        }
        return response.withStatus(operation.getResponse().getStatus().value());
    }

    private MappingBuilder request(Operation operation) {
        return this.queryParams(this.requestHeaders(this.requestBuilder(operation), operation), operation);
    }

    private MappingBuilder queryParams(MappingBuilder request, Operation operation) {
        String rawQuery = operation.getRequest().getUri().getRawQuery();
        if (!StringUtils.hasText((String)rawQuery)) {
            return request;
        }
        for (String queryPair : rawQuery.split("&")) {
            String[] splitQueryPair = queryPair.split("=");
            String value = splitQueryPair.length > 1 ? splitQueryPair[1] : "";
            request = request.withQueryParam(splitQueryPair[0], WireMock.equalTo((String)value));
        }
        return request;
    }

    private MappingBuilder requestHeaders(MappingBuilder request, Operation operation) {
        HttpHeaders headers = operation.getRequest().getHeaders();
        for (String name : headers.keySet()) {
            if (this.headerBlackList.contains(name.toLowerCase()) || "content-type".equalsIgnoreCase(name) && this.contentType != null) continue;
            request = request.withHeader(name, WireMock.equalTo((String)headers.getFirst(name)));
        }
        if (this.contentType != null) {
            request = request.withHeader("Content-Type", WireMock.matching((String)(Pattern.quote(this.contentType.toString()) + ".*")));
        }
        return request;
    }

    private MappingBuilder requestBuilder(Operation operation) {
        HttpMethod method = operation.getRequest().getMethod();
        if (method.equals((Object)HttpMethod.DELETE)) {
            return WireMock.delete((UrlPattern)this.requestPattern(operation));
        }
        if (method.equals((Object)HttpMethod.POST)) {
            return this.bodyPattern(WireMock.post((UrlPattern)this.requestPattern(operation)), operation.getRequest().getContentAsString());
        }
        if (method.equals((Object)HttpMethod.PUT)) {
            return this.bodyPattern(WireMock.put((UrlPattern)this.requestPattern(operation)), operation.getRequest().getContentAsString());
        }
        if (method.equals((Object)HttpMethod.PATCH)) {
            return this.bodyPattern(WireMock.patch((UrlPattern)this.requestPattern(operation)), operation.getRequest().getContentAsString());
        }
        if (method.equals((Object)HttpMethod.GET)) {
            return WireMock.get((UrlPattern)this.requestPattern(operation));
        }
        if (method.equals((Object)HttpMethod.HEAD)) {
            return WireMock.head((UrlPattern)this.requestPattern(operation));
        }
        if (method.equals((Object)HttpMethod.OPTIONS)) {
            return WireMock.options((UrlPattern)this.requestPattern(operation));
        }
        if (method.equals((Object)HttpMethod.TRACE)) {
            return WireMock.trace((UrlPattern)this.requestPattern(operation));
        }
        throw new UnsupportedOperationException("Unsupported method type: " + method);
    }

    private MappingBuilder bodyPattern(MappingBuilder builder, String content) {
        if (this.jsonPaths != null && !this.jsonPaths.isEmpty()) {
            for (String jsonPath : this.jsonPaths) {
                builder.withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)jsonPath));
            }
        } else if (StringUtils.hasText((String)content)) {
            if (this.hasJsonBodyRequestToMatch) {
                builder.withRequestBody((ContentPattern)WireMock.equalToJson((String)content));
            } else if (this.hasXmlBodyRequestToMatch) {
                builder.withRequestBody((ContentPattern)WireMock.equalToXml((String)content));
            } else {
                builder.withRequestBody((ContentPattern)WireMock.equalTo((String)content));
            }
        }
        return builder;
    }

    private UrlPattern requestPattern(Operation operation) {
        return WireMock.urlPathEqualTo((String)operation.getRequest().getUri().getPath());
    }

    private com.github.tomakehurst.wiremock.http.HttpHeaders responseHeaders(Operation operation) {
        HttpHeaders headers = operation.getResponse().getHeaders();
        com.github.tomakehurst.wiremock.http.HttpHeaders result = new com.github.tomakehurst.wiremock.http.HttpHeaders();
        for (String name : headers.keySet()) {
            if (this.headerBlackList.contains(name.toLowerCase())) continue;
            result = result.plus(new HttpHeader[]{new HttpHeader(name, (Collection)headers.get((Object)name))});
        }
        return result;
    }
}

