/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock.restdocs;

import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.web.reactive.server.EntityExchangeResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import wiremock.com.google.common.base.Optional;
import wiremock.org.apache.commons.codec.binary.Base64;
import wiremock.org.eclipse.jetty.server.handler.ContextHandler;

class WireMockHttpRequestAdapter
implements Request {
    private EntityExchangeResult<?> result;

    public WireMockHttpRequestAdapter(EntityExchangeResult<?> result) {
        this.result = result;
    }

    public String getUrl() {
        return this.result.getUrl().getRawPath();
    }

    public String getAbsoluteUrl() {
        return this.result.getUrl().toString();
    }

    public RequestMethod getMethod() {
        return new RequestMethod(this.result.getMethod().name());
    }

    public String getScheme() {
        return this.result.getUrl().getScheme();
    }

    public String getHost() {
        return this.result.getUrl().getHost();
    }

    public int getPort() {
        return this.result.getUrl().getPort();
    }

    public String getClientIp() {
        return "127.0.0.1";
    }

    public String getHeader(String key) {
        HttpHeaders headers = this.result.getRequestHeaders();
        return headers.containsKey((Object)key) ? headers.getFirst(key) : null;
    }

    public HttpHeader header(String key) {
        HttpHeaders headers = this.result.getRequestHeaders();
        return headers.containsKey((Object)key) ? new HttpHeader(key, (Collection)headers.getValuesAsList(key)) : null;
    }

    public ContentTypeHeader contentTypeHeader() {
        MediaType contentType = this.result.getRequestHeaders().getContentType();
        if (contentType == null) {
            return null;
        }
        return new ContentTypeHeader(contentType.toString());
    }

    public com.github.tomakehurst.wiremock.http.HttpHeaders getHeaders() {
        com.github.tomakehurst.wiremock.http.HttpHeaders target = new com.github.tomakehurst.wiremock.http.HttpHeaders();
        HttpHeaders headers = this.result.getRequestHeaders();
        for (String key : headers.keySet()) {
            target = target.plus(new HttpHeader[]{new HttpHeader(key, (Collection)headers.getValuesAsList(key))});
        }
        return target;
    }

    public boolean containsHeader(String key) {
        return this.result.getRequestHeaders().containsKey((Object)key);
    }

    public Set<String> getAllHeaderKeys() {
        return this.result.getRequestHeaders().keySet();
    }

    public Map<String, Cookie> getCookies() {
        return new LinkedHashMap<String, Cookie>();
    }

    public QueryParameter queryParameter(String key) {
        String query = this.result.getUrl().getRawQuery();
        if (query == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        String[] strings = StringUtils.split((String)query, (String)"&");
        if (strings == null) {
            return null;
        }
        for (String name : strings) {
            if (name.equals(key)) {
                values.add("");
                continue;
            }
            if (!name.startsWith(key + "=")) continue;
            values.add(name.substring(name.indexOf("=") + 1));
        }
        if (values.isEmpty()) {
            return null;
        }
        return new QueryParameter(key, values);
    }

    public byte[] getBody() {
        return this.result.getRequestBodyContent();
    }

    public String getBodyAsString() {
        return new String(this.result.getRequestBodyContent(), Charset.forName("UTF-8"));
    }

    public String getBodyAsBase64() {
        return Base64.encodeBase64String((byte[])this.result.getRequestBodyContent());
    }

    public boolean isMultipart() {
        return MediaType.MULTIPART_FORM_DATA.isCompatibleWith(this.result.getRequestHeaders().getContentType());
    }

    public Collection<Request.Part> getParts() {
        try {
            return this.getWireMockParts();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Collection<Request.Part> getWireMockParts() {
        MockHttpServletRequest request = MockMvcRequestBuilders.request((HttpMethod)this.result.getMethod(), (String)this.result.getUriTemplate(), (Object[])new Object[0]).contentType(this.result.getRequestHeaders().getContentType()).content(this.result.getRequestBodyContent()).buildRequest((ServletContext)new ContextHandler.NoContext());
        try {
            return new StandardMultipartHttpServletRequest((HttpServletRequest)request).getParts().stream().map(part -> this.partFromServletPart((Part)part)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Request.Part partFromServletPart(final Part part) {
        return new Request.Part(){

            public String getName() {
                return part.getName();
            }

            public HttpHeader getHeader(String name) {
                return new HttpHeader(name, new String[]{part.getHeader(name)});
            }

            public com.github.tomakehurst.wiremock.http.HttpHeaders getHeaders() {
                com.github.tomakehurst.wiremock.http.HttpHeaders headers = new com.github.tomakehurst.wiremock.http.HttpHeaders();
                for (String s : part.getHeaderNames()) {
                    headers.plus(new HttpHeader[]{new HttpHeader(s, new String[]{part.getHeader(s)})});
                }
                return headers;
            }

            public Body getBody() {
                try {
                    byte[] targetArray = new byte[part.getInputStream().available()];
                    return new Body(targetArray);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    public Request.Part getPart(String name) {
        return this.getWireMockParts().stream().filter(part -> name.equals(part.getName())).findFirst().get();
    }

    public boolean isBrowserProxyRequest() {
        return false;
    }

    public Optional<Request> getOriginalRequest() {
        return Optional.absent();
    }
}

