/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyAssertionLineCreator;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.EscapedString;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.Then;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.ContentType;

class GenericTextBodyThen
implements Then {
    private final BlockBuilder blockBuilder;
    private final BodyAssertionLineCreator bodyAssertionLineCreator;
    private final BodyParser bodyParser;
    private final ComparisonBuilder comparisonBuilder;

    GenericTextBodyThen(BlockBuilder blockBuilder, GeneratedClassMetaData metaData, BodyParser bodyParser, ComparisonBuilder comparisonBuilder) {
        this.blockBuilder = blockBuilder;
        this.bodyParser = bodyParser;
        this.comparisonBuilder = comparisonBuilder;
        this.bodyAssertionLineCreator = new BodyAssertionLineCreator(blockBuilder, metaData, this.bodyParser.byteArrayString(), this.comparisonBuilder);
    }

    @Override
    public MethodVisitor<Then> apply(SingleContractMetadata metadata) {
        Object convertedResponseBody = this.bodyParser.convertResponseBody(metadata);
        if (convertedResponseBody instanceof String) {
            String escaped = this.bodyParser.escapeForSimpleTextAssertion(convertedResponseBody.toString());
            convertedResponseBody = new EscapedString(escaped);
        }
        this.simpleTextResponseBodyCheck(metadata, convertedResponseBody);
        return this;
    }

    private void simpleTextResponseBodyCheck(SingleContractMetadata metadata, Object convertedResponseBody) {
        this.blockBuilder.addLineWithEnding(this.getSimpleResponseBodyString(this.bodyParser.responseAsString()));
        this.bodyAssertionLineCreator.appendBodyAssertionLine(metadata, "", convertedResponseBody);
        this.blockBuilder.addEndingIfNotPresent();
    }

    private String getSimpleResponseBodyString(String responseString) {
        return "String responseBody = " + responseString + this.blockBuilder.getLineEnding();
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        ContentType outputTestContentType = metadata.getOutputTestContentType();
        return outputTestContentType != ContentType.JSON && outputTestContentType != ContentType.XML && this.bodyParser.responseBody(metadata) != null && !(this.bodyParser.responseBody(metadata).getServerValue() instanceof FromFileProperty);
    }
}

