/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.JavaMessagingBodyParser;
import org.springframework.cloud.contract.verifier.builder.RestAssuredBodyParser;

interface ComparisonBuilder {
    public static final ComparisonBuilder JAVA_HTTP_INSTANCE = () -> RestAssuredBodyParser.INSTANCE;
    public static final ComparisonBuilder JAVA_MESSAGING_INSTANCE = () -> JavaMessagingBodyParser.INSTANCE;

    default public String createComparison(Object headerValue) {
        if (headerValue instanceof Pattern) {
            return this.matches((Pattern)headerValue);
        }
        if (headerValue instanceof Number) {
            return this.isEqualTo((Number)headerValue);
        }
        String escapedHeader = this.convertUnicodeEscapesIfRequired(headerValue.toString());
        return this.isEqualTo(escapedHeader);
    }

    default public String createUnescapedComparison(Object headerValue) {
        if (headerValue instanceof Pattern) {
            return this.createComparison((Pattern)headerValue);
        }
        if (headerValue instanceof Number) {
            return this.isEqualTo((Number)headerValue);
        }
        return this.isEqualTo(headerValue.toString());
    }

    default public String assertThat(String object) {
        return "assertThat(" + object + ")";
    }

    default public String assertThatIsNotNull(String object) {
        return this.assertThat(object) + this.isNotNull();
    }

    default public String assertThat(String object, Object valueToCompareAgainst) {
        return this.assertThat(object) + this.createComparison(valueToCompareAgainst);
    }

    default public String assertThatUnescaped(String object, Object valueToCompareAgainst) {
        return this.assertThat(object) + this.createUnescapedComparison(valueToCompareAgainst);
    }

    default public String isEqualTo(String escapedHeaderValue) {
        return this.isEqualToUnquoted(this.bodyParser().quotedEscapedShortText(escapedHeaderValue));
    }

    default public String isEqualToUnquoted(String unquoted) {
        return ".isEqualTo(" + unquoted + ")";
    }

    default public String isEqualTo(Number number) {
        Object numberString = number instanceof Long ? number.toString() + "L" : number.toString();
        return ".isEqualTo(" + (String)numberString + ")";
    }

    default public String isNotNull() {
        return ".isNotNull()";
    }

    default public String matches(Pattern pattern) {
        String escapedPattern = StringEscapeUtils.escapeJava((String)pattern.pattern());
        return ".matches(" + this.bodyParser().quotedEscapedShortText(escapedPattern) + ")";
    }

    default public String matches(String pattern) {
        return ".matches(" + this.bodyParser().quotedShortText(pattern) + ")";
    }

    default public String matchesEscaped(String pattern) {
        return ".matches(" + this.bodyParser().quotedEscapedShortText(pattern) + ")";
    }

    default public String convertUnicodeEscapesIfRequired(String json) {
        String unescapedJson = StringEscapeUtils.unescapeJson((String)json);
        return StringEscapeUtils.escapeJava((String)unescapedJson);
    }

    public BodyParser bodyParser();
}

