/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.amqp;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.cloud.contract.verifier.util.MetadataUtil;
import org.springframework.cloud.contract.verifier.util.SpringCloudContractMetadata;

public class AmqpMetadata
implements SpringCloudContractMetadata {
    public static final String METADATA_KEY = "amqp";
    private MessageAmqpMetadata input = new MessageAmqpMetadata();
    private MessageAmqpMetadata outputMessage = new MessageAmqpMetadata();

    public MessageAmqpMetadata getInput() {
        return this.input;
    }

    public void setInput(MessageAmqpMetadata input) {
        this.input = input;
    }

    public MessageAmqpMetadata getOutputMessage() {
        return this.outputMessage;
    }

    public void setOutputMessage(MessageAmqpMetadata outputMessage) {
        this.outputMessage = outputMessage;
    }

    public static AmqpMetadata fromMetadata(Map<String, Object> metadata) {
        return MetadataUtil.fromMetadata(metadata, METADATA_KEY, new AmqpMetadata());
    }

    @Override
    public String key() {
        return METADATA_KEY;
    }

    @Override
    public String description() {
        return "Metadata for AMQP based communication";
    }

    @Override
    public List<Class> additionalClassesToLookAt() {
        return Collections.singletonList(MessageProperties.class);
    }

    public static class ConnectToBroker {
        private String additionalOptions;
        private String declareQueueWithName;

        public String getAdditionalOptions() {
            return this.additionalOptions;
        }

        public void setAdditionalOptions(String additionalOptions) {
            this.additionalOptions = additionalOptions;
        }

        public String getDeclareQueueWithName() {
            return this.declareQueueWithName;
        }

        public void setDeclareQueueWithName(String declareQueueWithName) {
            this.declareQueueWithName = declareQueueWithName;
        }
    }

    public static class MessageAmqpMetadata {
        private MessageProperties messageProperties;
        private ConnectToBroker connectToBroker = new ConnectToBroker();

        public MessageProperties getMessageProperties() {
            return this.messageProperties;
        }

        public void setMessageProperties(MessageProperties messageProperties) {
            this.messageProperties = messageProperties;
        }

        public ConnectToBroker getConnectToBroker() {
            return this.connectToBroker;
        }

        public void setConnectToBroker(ConnectToBroker connectToBroker) {
            this.connectToBroker = connectToBroker;
        }
    }
}

