/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.kafka;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.springframework.kafka.support.converter.MessagingMessageConverter;
import org.springframework.kafka.test.utils.KafkaTestUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;

class Receiver {
    private static final Log log = LogFactory.getLog(Receiver.class);
    private final MessagingMessageConverter messagingMessageConverter = new MessagingMessageConverter();
    private final Map<String, Consumer> consumers;

    Receiver(Map<String, Consumer> consumers) {
        this.consumers = consumers;
    }

    Message receive(String topic, long timeout, TimeUnit timeUnit) {
        Consumer consumer = this.consumers.get(topic);
        if (consumer == null) {
            throw new IllegalStateException("No consumer set up for topic [" + topic + "]");
        }
        ConsumerRecord record = KafkaTestUtils.getSingleRecord((Consumer)consumer, (String)topic, (long)timeUnit.toMillis(timeout));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got a single record for destination [" + topic + "]"));
        }
        return this.toMessage(consumer, record);
    }

    Message toMessage(Consumer consumer, ConsumerRecord<?, ?> record) {
        Map<String, Object> headersMap = this.toMap(record.headers());
        this.messagingMessageConverter.commonHeaders(null, consumer, headersMap, record.key(), (Object)record.topic(), (Object)record.partition(), (Object)record.offset(), (Object)(record.timestampType() != null ? record.timestampType().name() : null), (Object)record.timestamp());
        headersMap.put("kafka_messageKey", record.key());
        Object textPayload = record.value();
        if (textPayload instanceof String && ((String)textPayload).contains("payload") && ((String)textPayload).contains("headers")) {
            try {
                Object object = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse((String)textPayload);
                JSONObject jo = (JSONObject)object;
                String payload = (String)jo.get((Object)"payload");
                JSONObject headersInJson = (JSONObject)jo.get((Object)"headers");
                headersMap.putAll((Map<String, Object>)headersInJson);
                return MessageBuilder.createMessage((Object)this.unquoted(payload), (MessageHeaders)new MessageHeaders(headersMap));
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return MessageBuilder.createMessage((Object)this.unquoted(textPayload), (MessageHeaders)new MessageHeaders(headersMap));
    }

    private Map<String, Object> toMap(Headers headers) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Header header : headers) {
            map.put(header.key(), header.value());
        }
        return map;
    }

    private Object unquoted(Object value) {
        String textPayload;
        String string = textPayload = value instanceof byte[] ? new String((byte[])value) : value.toString();
        if (textPayload.startsWith("\"") && textPayload.endsWith("\"")) {
            return textPayload.substring(1, textPayload.length() - 1).replace("\\\"", "\"");
        }
        return textPayload;
    }
}

