/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class BlockBuilder
implements GroovyObject {
    private final StringBuilder builder;
    private final String spacer;
    private int indents;
    private String lineEnding;
    private String labelPrefix;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public BlockBuilder(String spacer) {
        StringBuilder stringBuilder;
        String string;
        MetaClass metaClass;
        String string2;
        String string3;
        this.lineEnding = string3 = "";
        this.labelPrefix = string2 = "";
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.spacer = string = spacer;
        this.builder = stringBuilder = new StringBuilder();
    }

    public BlockBuilder setupLineEnding(String lineEnding) {
        String string;
        this.lineEnding = string = lineEnding;
        return this;
    }

    public BlockBuilder setupLabelPrefix(String labelPrefix) {
        String string;
        this.labelPrefix = string = labelPrefix;
        return this;
    }

    public String getLineEnding() {
        return this.lineEnding;
    }

    public BlockBuilder appendWithLabelPrefix(String label) {
        return this.append(this.labelPrefix).append(label);
    }

    public BlockBuilder startBlock() {
        int n = this.indents;
        this.indents = n + 1;
        return this;
    }

    public BlockBuilder endBlock() {
        int n = this.indents;
        this.indents = n - 1;
        return this;
    }

    public BlockBuilder indent() {
        this.startBlock().startBlock();
        return this;
    }

    public BlockBuilder unindent() {
        this.endBlock().endBlock();
        return this;
    }

    public BlockBuilder addLine(String line) {
        return this.addIndented(line).append("\n");
    }

    public BlockBuilder addIndented(String line) {
        return this.addIndentation().append(line);
    }

    public BlockBuilder addIndented(Runnable runnable) {
        this.addIndentation();
        runnable.run();
        return this;
    }

    public BlockBuilder addLineWithEnding(String line) {
        this.addIndentation();
        this.append(line).addEndingIfNotPresent().addEmptyLine();
        return this;
    }

    public BlockBuilder addEndingIfNotPresent() {
        this.addAtTheEnd(this.lineEnding);
        return this;
    }

    public BlockBuilder addEmptyLine() {
        StringGroovyMethods.leftShift((StringBuilder)this.builder, (Object)"\n");
        return this;
    }

    public BlockBuilder appendWithSpace(String text) {
        return this.addAtTheEnd(" ").append(text);
    }

    public BlockBuilder appendWithSpace(Runnable runnable) {
        this.addAtTheEnd(" ");
        runnable.run();
        return this;
    }

    public BlockBuilder append(Runnable runnable) {
        runnable.run();
        return this;
    }

    public BlockBuilder append(String string) {
        StringGroovyMethods.leftShift((StringBuilder)this.builder, (Object)string);
        return this;
    }

    public BlockBuilder addIndentation() {
        public final class _addIndentation_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addIndentation_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return StringGroovyMethods.leftShift((StringBuilder)((BlockBuilder)this.getThisObject()).builder, (Object)((BlockBuilder)this.getThisObject()).spacer);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addIndentation_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.times((Number)this.indents, (Closure)new _addIndentation_closure1(this, this));
        return this;
    }

    BlockBuilder inBraces(Runnable runnable) {
        this.builder.append("{\n");
        this.startBlock();
        runnable.run();
        this.endBlock();
        this.addAtTheEnd("\n");
        this.addLine("}");
        return this;
    }

    public boolean endsWith(String text) {
        return this.builder.toString().endsWith(text);
    }

    public BlockBuilder addAtTheEndIfEndsWithAChar(String toAdd) {
        char lastChar = this.builder.charAt(this.builder.length() - 1);
        if (Character.isLetter(lastChar)) {
            this.builder.append(toAdd);
        }
        return this;
    }

    public BlockBuilder addAtTheEnd(String toAdd) {
        String lastChar = (String)ScriptBytecodeAdapter.asType((Object)Character.valueOf(this.builder.charAt(this.builder.length() - 1)), String.class);
        String secondLastChar = this.builder.length() >= 2 ? (String)ScriptBytecodeAdapter.asType((Object)Character.valueOf(this.builder.charAt(this.builder.length() - 2)), String.class) : "";
        boolean isEndWithNewLine = this.endsWithNewLine(lastChar);
        boolean lastCharSpecial = this.aSpecialSign(lastChar, toAdd);
        boolean secondLastCharSpecial = this.aSpecialSign(secondLastChar, toAdd);
        boolean lineEndingToAdd = ScriptBytecodeAdapter.compareEqual((Object)toAdd, (Object)this.lineEnding);
        if (ScriptBytecodeAdapter.compareEqual((Object)lastChar, (Object)toAdd)) {
            return this;
        }
        if (!isEndWithNewLine && lastCharSpecial && lineEndingToAdd) {
            return this;
        }
        if (isEndWithNewLine && secondLastCharSpecial) {
            return this;
        }
        if (isEndWithNewLine && !secondLastCharSpecial) {
            this.builder.replace(this.builder.length() - 1, this.builder.length(), toAdd);
            StringGroovyMethods.leftShift((StringBuilder)this.builder, (Object)"\n");
        } else {
            StringGroovyMethods.leftShift((StringBuilder)this.builder, (Object)toAdd);
        }
        return this;
    }

    private boolean endsWithNewLine(String character) {
        return ScriptBytecodeAdapter.compareEqual((Object)character, (Object)Character.valueOf('\n'));
    }

    private boolean aSpecialSign(String character, String toAdd) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)character)) {
            return false;
        }
        return ScriptBytecodeAdapter.compareEqual((Object)character, (Object)Character.valueOf('{')) || ScriptBytecodeAdapter.compareEqual((Object)character, (Object)this.spacer) && ScriptBytecodeAdapter.compareEqual((Object)toAdd, (Object)this.spacer) || ScriptBytecodeAdapter.compareEqual((Object)character, (Object)this.spacer) && ScriptBytecodeAdapter.compareEqual((Object)toAdd, (Object)Character.valueOf(' ')) || ScriptBytecodeAdapter.compareEqual((Object)character, (Object)toAdd) || this.endsWithNewLine(character) && (ScriptBytecodeAdapter.compareEqual((Object)toAdd, (Object)Character.valueOf('\n')) || ScriptBytecodeAdapter.compareEqual((Object)toAdd, (Object)Character.valueOf(' ')) || ScriptBytecodeAdapter.compareEqual((Object)toAdd, (Object)this.lineEnding));
    }

    public BlockBuilder updateContents(String contents) {
        this.builder.replace(0, this.builder.length(), contents);
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BlockBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

