/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.util.HashMap;
import org.apache.maven.settings.crypto.DefaultSettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.springframework.util.StringUtils;

public class MavenSettings {
    private static final String MAVEN_USER_CONFIG_DIRECTORY = "maven.user.config.dir";
    private static final String SECURITY_XML = "settings-security.xml";
    private final String homeDir;

    public MavenSettings() {
        this(MavenSettings.userSettings());
    }

    public MavenSettings(String homeDir) {
        this.homeDir = homeDir;
    }

    private static String fromSystemPropOrEnv(String prop) {
        String resolvedProp = System.getProperty(prop);
        if (StringUtils.hasText((String)resolvedProp)) {
            return resolvedProp;
        }
        return System.getenv(prop);
    }

    private static String userSettings() {
        String user = MavenSettings.fromSystemPropOrEnv(MAVEN_USER_CONFIG_DIRECTORY);
        if (user == null) {
            return System.getProperty("user.home");
        }
        return user;
    }

    public SettingsDecrypter createSettingsDecrypter() {
        File file = new File(this.homeDir, SECURITY_XML);
        String configurationFilePath = file.getAbsolutePath();
        return new DefaultSettingsDecrypter((SecDispatcher)new SpringCloudContractSecDispatcher((PlexusCipher)new DefaultPlexusCipher(), configurationFilePath));
    }

    private static class SpringCloudContractSecDispatcher
    extends DefaultSecDispatcher {
        SpringCloudContractSecDispatcher(PlexusCipher cipher, String configurationFile) {
            super(cipher, new HashMap(), configurationFile);
        }
    }
}

