/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.junit;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.BatchStubRunnerFactory;
import org.springframework.cloud.contract.stubrunner.HttpServerStubConfigurer;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.cloud.contract.stubrunner.StubNotFoundException;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.stubrunner.junit.ExceptionThrowingMessageVerifier;
import org.springframework.cloud.contract.stubrunner.junit.PortStubRunnerExtensionOptions;
import org.springframework.cloud.contract.stubrunner.junit.StubRunnerExtensionOptions;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierReceiver;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierSender;

public class StubRunnerExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
StubFinder,
StubRunnerExtensionOptions {
    private static final String DELIMITER = ":";
    private static final String LATEST_VERSION = "+";
    private static final Log LOG = LogFactory.getLog(StubRunnerExtension.class);
    StubRunnerExtension delegate = this;
    private AtomicBoolean beforeAllCalled = new AtomicBoolean();
    private AtomicBoolean afterAllCalled = new AtomicBoolean();
    private BatchStubRunner stubFinder;
    private StubRunnerOptionsBuilder stubRunnerOptionsBuilder = new StubRunnerOptionsBuilder(StubRunnerOptions.fromSystemProps());
    private MessageVerifierSender verifierSender = new ExceptionThrowingMessageVerifier();
    private MessageVerifierReceiver verifierReceiver = new ExceptionThrowingMessageVerifier();

    public StubRunnerExtension() {
    }

    StubRunnerExtension(StubRunnerExtension delegate) {
        this.delegate = delegate;
    }

    public void afterAll(ExtensionContext extensionContext) {
        try {
            this.after();
        }
        finally {
            this.afterAllCalled.set(true);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (this.extensionOverStaticField()) {
            return;
        }
        this.after();
    }

    private boolean extensionOverStaticField() {
        return this.afterAllCalled.get() || this.beforeAllCalled.get();
    }

    public void beforeAll(ExtensionContext extensionContext) {
        try {
            this.before();
        }
        finally {
            this.beforeAllCalled.set(true);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.extensionOverStaticField()) {
            return;
        }
        this.before();
    }

    private void before() {
        this.stubFinder(new BatchStubRunnerFactory(this.builder().build(), this.verifierSender()).buildBatchStubRunner());
        this.stubFinder().runStubs();
    }

    private void after() {
        try {
            this.stubFinder().close();
        }
        catch (IOException exception) {
            LOG.warn((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public URL findStubUrl(String groupId, String artifactId) throws StubNotFoundException {
        return this.stubFinder().findStubUrl(groupId, artifactId);
    }

    @Override
    public URL findStubUrl(String ivyNotation) throws StubNotFoundException {
        return this.stubFinder().findStubUrl(ivyNotation);
    }

    @Override
    public RunningStubs findAllRunningStubs() {
        return this.stubFinder().findAllRunningStubs();
    }

    @Override
    public Map<StubConfiguration, Collection<Contract>> getContracts() {
        return this.stubFinder().getContracts();
    }

    @Override
    public boolean trigger(String ivyNotation, String labelName) {
        boolean result = this.stubFinder().trigger(ivyNotation, labelName);
        if (!result) {
            throw new IllegalStateException("Failed to trigger a message with notation [" + ivyNotation + "] and label [" + labelName + "]");
        }
        return result;
    }

    @Override
    public boolean trigger(String labelName) {
        boolean result = this.stubFinder().trigger(labelName);
        if (!result) {
            throw new IllegalStateException("Failed to trigger a message with label [" + labelName + "]");
        }
        return result;
    }

    @Override
    public boolean trigger() {
        boolean result = this.stubFinder().trigger();
        if (!result) {
            throw new IllegalStateException("Failed to trigger a message");
        }
        return result;
    }

    @Override
    public Map<String, Collection<String>> labels() {
        return this.stubFinder().labels();
    }

    @Override
    public StubRunnerExtension messageVerifierSender(MessageVerifierSender messageVerifier) {
        this.verifierSender(messageVerifier);
        return this.delegate;
    }

    @Override
    public StubRunnerExtension messageVerifierReceiver(MessageVerifierReceiver messageVerifier) {
        this.verifierReceiver(messageVerifier);
        return this.delegate;
    }

    @Override
    public StubRunnerExtension options(StubRunnerOptions stubRunnerOptions) {
        this.builder().withOptions(stubRunnerOptions);
        return this.delegate;
    }

    @Override
    public StubRunnerExtension minPort(int minPort) {
        this.builder().withMinPort(minPort);
        return this.delegate;
    }

    @Override
    public StubRunnerExtension maxPort(int maxPort) {
        this.builder().withMaxPort(maxPort);
        return this.delegate;
    }

    @Override
    public StubRunnerExtension repoRoot(String repoRoot) {
        this.builder().withStubRepositoryRoot(repoRoot);
        return this.delegate;
    }

    @Override
    public StubRunnerExtension stubsMode(StubRunnerProperties.StubsMode stubsMode) {
        this.builder().withStubsMode(stubsMode);
        return this.delegate;
    }

    @Override
    public PortStubRunnerExtension downloadStub(String groupId, String artifactId, String version, String classifier) {
        this.builder().withStubs(groupId + DELIMITER + artifactId + DELIMITER + version + DELIMITER + classifier);
        return new PortStubRunnerExtension(this.delegate);
    }

    @Override
    public PortStubRunnerExtension downloadLatestStub(String groupId, String artifactId, String classifier) {
        this.builder().withStubs(groupId + DELIMITER + artifactId + ":+:" + classifier);
        return new PortStubRunnerExtension(this.delegate);
    }

    @Override
    public PortStubRunnerExtension downloadStub(String groupId, String artifactId, String version) {
        this.builder().withStubs(groupId + DELIMITER + artifactId + DELIMITER + version);
        return new PortStubRunnerExtension(this.delegate);
    }

    @Override
    public PortStubRunnerExtension downloadStub(String groupId, String artifactId) {
        this.builder().withStubs(groupId + DELIMITER + artifactId);
        return new PortStubRunnerExtension(this.delegate);
    }

    @Override
    public PortStubRunnerExtension downloadStub(String ivyNotation) {
        this.builder().withStubs(ivyNotation);
        return new PortStubRunnerExtension(this.delegate);
    }

    @Override
    public StubRunnerExtension downloadStubs(String ... ivyNotations) {
        this.builder().withStubs(Arrays.asList(ivyNotations));
        return new PortStubRunnerExtension(this.delegate);
    }

    @Override
    public StubRunnerExtension downloadStubs(List<String> ivyNotations) {
        this.builder().withStubs(ivyNotations);
        return new PortStubRunnerExtension(this.delegate);
    }

    @Override
    public StubRunnerExtension withStubPerConsumer(boolean stubPerConsumer) {
        this.builder().withStubPerConsumer(stubPerConsumer);
        return new PortStubRunnerExtension(this.delegate);
    }

    @Override
    public StubRunnerExtension withConsumerName(String consumerName) {
        this.builder().withConsumerName(consumerName);
        return new PortStubRunnerExtension(this.delegate);
    }

    @Override
    public StubRunnerExtension withMappingsOutputFolder(String mappingsOutputFolder) {
        this.builder().withMappingsOutputFolder(mappingsOutputFolder);
        return new PortStubRunnerExtension(this.delegate);
    }

    @Override
    public StubRunnerExtension withDeleteStubsAfterTest(boolean deleteStubsAfterTest) {
        this.builder().withDeleteStubsAfterTest(deleteStubsAfterTest);
        return new PortStubRunnerExtension(this.delegate);
    }

    @Override
    public StubRunnerExtension withGenerateStubs(boolean generateStubs) {
        this.builder().withGenerateStubs(generateStubs);
        return new PortStubRunnerExtension(this.delegate);
    }

    @Override
    public StubRunnerExtension failOnNoStubs(boolean failOnNoStubs) {
        this.builder().withFailOnNoStubs(failOnNoStubs);
        return new PortStubRunnerExtension(this.delegate);
    }

    @Override
    public StubRunnerExtension withProperties(Map<String, String> properties) {
        this.builder().withProperties(properties);
        return new PortStubRunnerExtension(this.delegate);
    }

    @Override
    public StubRunnerExtension withHttpServerStubConfigurer(Class<? extends HttpServerStubConfigurer> httpServerStubConfigurer) {
        this.builder().withHttpServerStubConfigurer(httpServerStubConfigurer);
        return new PortStubRunnerExtension(this.delegate);
    }

    BatchStubRunner stubFinder() {
        return this.delegate.stubFinder;
    }

    void stubFinder(BatchStubRunner stubFinder) {
        this.delegate.stubFinder = stubFinder;
    }

    StubRunnerOptionsBuilder builder() {
        return this.delegate.stubRunnerOptionsBuilder;
    }

    MessageVerifierSender verifierSender() {
        return this.delegate.verifierSender;
    }

    MessageVerifierReceiver verifierReceiver() {
        return this.delegate.verifierReceiver;
    }

    void verifierSender(MessageVerifierSender verifier) {
        this.delegate.verifierSender = verifier;
    }

    void verifierReceiver(MessageVerifierReceiver verifier) {
        this.delegate.verifierReceiver = verifier;
    }

    public static class PortStubRunnerExtension
    extends StubRunnerExtension
    implements PortStubRunnerExtensionOptions {
        PortStubRunnerExtension(StubRunnerExtension delegate) {
            super(delegate);
        }

        @Override
        public StubRunnerExtension withPort(Integer port) {
            this.builder().withPort(port);
            return this.delegate;
        }
    }
}

