/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud.loadbalancer;

import java.io.Closeable;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.reactive.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubMapperProperties;
import org.springframework.cloud.contract.stubrunner.spring.cloud.loadbalancer.StubbedServiceInstance;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import reactor.core.publisher.Mono;

class StubRunnerLoadBalancerClientFactory
extends LoadBalancerClientFactory
implements Closeable {
    private final StubFinder stubFinder;
    private final StubMapperProperties stubMapperProperties;

    StubRunnerLoadBalancerClientFactory(StubFinder stubFinder, StubMapperProperties stubMapperProperties) {
        this.stubFinder = stubFinder;
        this.stubMapperProperties = stubMapperProperties;
    }

    public ReactiveLoadBalancer<ServiceInstance> getInstance(String serviceId) {
        return request -> Mono.just((Object)new DefaultResponse((ServiceInstance)new StubbedServiceInstance(this.stubFinder, this.stubMapperProperties, serviceId)));
    }

    @Override
    public void close() {
        StubbedServiceInstance.CACHE.clear();
    }
}

