/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.GitRepo;
import org.springframework.cloud.contract.stubrunner.GitStubDownloaderProperties;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.TemporaryFileStorage;
import org.springframework.core.io.Resource;

class GitContractsRepo {
    private static final Log log = LogFactory.getLog(GitContractsRepo.class);
    private static final String TEMP_DIR_PREFIX = "git-contracts";
    static final Map<Resource, File> CACHED_LOCATIONS = new ConcurrentHashMap<Resource, File>();
    private final StubRunnerOptions options;

    GitContractsRepo(StubRunnerOptions options) {
        this.options = options;
    }

    File clonedRepo(Resource repo) {
        File file = CACHED_LOCATIONS.get(repo);
        GitStubDownloaderProperties properties = new GitStubDownloaderProperties(repo, this.options);
        if (file == null) {
            File tmpDirWhereStubsWillBeUnzipped = TemporaryFileStorage.createTempDir(TEMP_DIR_PREFIX);
            GitRepo gitRepo = new GitRepo(tmpDirWhereStubsWillBeUnzipped, properties);
            file = gitRepo.cloneProject(properties.url);
            gitRepo.checkout(file, properties.branch);
            CACHED_LOCATIONS.put(repo, file);
            if (log.isDebugEnabled()) {
                log.debug((Object)("The project hasn't already been cloned. Cloned it to [" + file + "]"));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The project has already been cloned to [" + file + "]. Will reset any changes and pull the latest ones."));
            }
            GitRepo gitRepo = new GitRepo(file, properties);
            gitRepo.reset(file);
            gitRepo.pull(file);
        }
        return file;
    }
}

