/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilderProvider;
import org.springframework.cloud.contract.stubrunner.StubRunnerFactory;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpStubMessages;

public class BatchStubRunnerFactory {
    private final StubRunnerOptions stubRunnerOptions;
    private final StubDownloader stubDownloader;
    private final MessageVerifier<?> contractVerifierMessaging;

    public BatchStubRunnerFactory(StubRunnerOptions stubRunnerOptions) {
        this(stubRunnerOptions, (MessageVerifier)new NoOpStubMessages());
    }

    public BatchStubRunnerFactory(StubRunnerOptions stubRunnerOptions, MessageVerifier verifier) {
        this(stubRunnerOptions, BatchStubRunnerFactory.aetherStubDownloader(stubRunnerOptions), verifier);
    }

    private static StubDownloader aetherStubDownloader(StubRunnerOptions stubRunnerOptions) {
        StubDownloaderBuilderProvider provider = new StubDownloaderBuilderProvider();
        return provider.get(stubRunnerOptions, new StubDownloaderBuilder[0]);
    }

    public BatchStubRunnerFactory(StubRunnerOptions stubRunnerOptions, StubDownloader stubDownloader) {
        this(stubRunnerOptions, stubDownloader, (MessageVerifier<?>)new NoOpStubMessages());
    }

    public BatchStubRunnerFactory(StubRunnerOptions stubRunnerOptions, StubDownloader stubDownloader, MessageVerifier<?> contractVerifierMessaging) {
        this.stubRunnerOptions = stubRunnerOptions;
        this.stubDownloader = stubDownloader;
        this.contractVerifierMessaging = contractVerifierMessaging;
    }

    public BatchStubRunner buildBatchStubRunner() {
        StubRunnerFactory stubRunnerFactory = new StubRunnerFactory(this.stubRunnerOptions, this.stubDownloader, this.contractVerifierMessaging);
        return new BatchStubRunner(stubRunnerFactory.createStubsFromServiceConfiguration());
    }
}

