/*
 * Decompiled with CFR 0.152.
 */
package com.example.loan;

import com.example.loan.model.FraudCheckStatus;
import com.example.loan.model.FraudServiceRequest;
import com.example.loan.model.FraudServiceResponse;
import com.example.loan.model.LoanApplication;
import com.example.loan.model.LoanApplicationResult;
import com.example.loan.model.LoanApplicationStatus;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class LoanApplicationService {
    private static final String FRAUD_SERVICE_JSON_VERSION_1 = "application/vnd.fraud.v1+json";
    private final RestTemplate restTemplate = new RestTemplate();
    private String fraudUrl = "http://localhost:8080";

    public LoanApplicationResult loanApplication(LoanApplication loanApplication) {
        FraudServiceRequest request = new FraudServiceRequest(loanApplication);
        FraudServiceResponse response = this.sendRequestToFraudDetectionService(request);
        return this.buildResponseFromFraudResult(response);
    }

    private FraudServiceResponse sendRequestToFraudDetectionService(FraudServiceRequest request) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", FRAUD_SERVICE_JSON_VERSION_1);
        ResponseEntity response = this.restTemplate.exchange(this.fraudUrl + "/fraudcheck", HttpMethod.PUT, new HttpEntity((Object)request, (MultiValueMap)httpHeaders), FraudServiceResponse.class, new Object[0]);
        return (FraudServiceResponse)response.getBody();
    }

    private LoanApplicationResult buildResponseFromFraudResult(FraudServiceResponse response) {
        LoanApplicationStatus applicationStatus = null;
        if (FraudCheckStatus.OK == response.getFraudCheckStatus()) {
            applicationStatus = LoanApplicationStatus.LOAN_APPLIED;
        } else if (FraudCheckStatus.FRAUD == response.getFraudCheckStatus()) {
            applicationStatus = LoanApplicationStatus.LOAN_APPLICATION_REJECTED;
        }
        return new LoanApplicationResult(applicationStatus, response.getRejectionReason());
    }

    public void setFraudUrl(String fraudUrl) {
        this.fraudUrl = fraudUrl;
    }
}

