/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.cloud.contract.spec.ContractDslExtensionsKt;
import org.springframework.cloud.contract.spec.internal.Body;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.BodyMatchersDsl;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.Common;
import org.springframework.cloud.contract.spec.internal.CommonDsl;
import org.springframework.cloud.contract.spec.internal.ContractDslMarker;
import org.springframework.cloud.contract.spec.internal.Cookies;
import org.springframework.cloud.contract.spec.internal.CookiesDsl;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.HeadersDsl;
import org.springframework.cloud.contract.spec.internal.HttpMethods;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;
import org.springframework.cloud.contract.spec.internal.Multipart;
import org.springframework.cloud.contract.spec.internal.MultipartDsl;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.spec.internal.ServerDslProperty;
import org.springframework.cloud.contract.spec.internal.Url;
import org.springframework.cloud.contract.spec.internal.UrlPath;
import org.springframework.cloud.contract.spec.util.RegexpUtils;

@ContractDslMarker
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b:\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001:\u0004\u0094\u0001\u0095\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002060\u00072\u0006\u0010\u0006\u001a\u000206J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\f\u001a\u000206J\u0014\u0010\f\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002070\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u00020\u00132\u0006\u0010<\u001a\u000206J\u0014\u0010<\u001a\u00020\u00132\f\u0010<\u001a\b\u0012\u0004\u0012\u0002070\u0007J\u001f\u0010\u0018\u001a\u00020=2\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020=0>\u00a2\u0006\u0002\b@J\u001f\u0010\u001e\u001a\u00020=2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020=0>\u00a2\u0006\u0002\b@J\u001a\u0010$\u001a\u00020%2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u0002070BJ7\u0010$\u001a\u00020%2*\u0010$\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u0002070D0C\"\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u0002070D\u00a2\u0006\u0002\u0010EJ\u001a\u0010$\u001a\u00020%2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u0002070DJ\u0014\u0010$\u001a\u00020%2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002070FJ\u000e\u0010$\u001a\u00020%2\u0006\u0010$\u001a\u000207J\u001f\u0010*\u001a\u00020=2\u0017\u0010G\u001a\u0013\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020=0>\u00a2\u0006\u0002\b@J\u001f\u00100\u001a\u00020=2\u0017\u0010G\u001a\u0013\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020=0>\u00a2\u0006\u0002\b@J\u0011\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0085\u0001\u001a\u000207J\u0011\u0010\u0086\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0085\u0001\u001a\u000207J\u0011\u0010\u0087\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0085\u0001\u001a\u000207J\u0011\u0010\u0088\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0085\u0001\u001a\u000207J\u0011\u0010\u0089\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0085\u0001\u001a\u000207J\u0011\u0010\u008a\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0085\u0001\u001a\u000207J\b\u0010\u008b\u0001\u001a\u00030\u0084\u0001J\u0016\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u0002070\u00072\u0007\u0010\u0085\u0001\u001a\u000209J\u0016\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u0002070\u00072\u0007\u0010\u0085\u0001\u001a\u000209J\u001c\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u0002070\u00072\r\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u0002070\u0007J\u001c\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u0002070\u00072\r\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u0002070\u0007J\u0017\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u0002070\u00072\b\u0010\u0085\u0001\u001a\u00030\u008d\u0001J\u0017\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u0002070\u00072\b\u0010\u0085\u0001\u001a\u00030\u008d\u0001J\u0017\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u0002070\u00072\b\u0010\u0085\u0001\u001a\u00030\u008e\u0001J\u0017\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u0002070\u00072\b\u0010\u0085\u0001\u001a\u00030\u008e\u0001J\u0018\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u0002070\u00072\t\u0010\u0085\u0001\u001a\u0004\u0018\u000107J\u0018\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u0002070\u00072\t\u0010\u0085\u0001\u001a\u0004\u0018\u000107J\u001d\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u0002070\u00072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;J\u001d\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u0002070\u00072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;J\u001d\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u0002070\u00072\u0006\u0010:\u001a\u00020;2\u0006\u00108\u001a\u000209J\u001d\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u0002070\u00072\u0006\u0010:\u001a\u00020;2\u0006\u00108\u001a\u000209J&\u0010\u008f\u0001\u001a\u0002092\u0017\u0010\u0090\u0001\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001060C\"\u0004\u0018\u000106\u00a2\u0006\u0003\u0010\u0091\u0001J\u000f\u0010\u0092\u0001\u001a\u00020\u0005H\u0000\u00a2\u0006\u0003\b\u0093\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001c\u00100\u001a\u0004\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0017\u0010J\u001a\b\u0012\u0004\u0012\u0002060\u00078F\u00a2\u0006\u0006\u001a\u0004\bK\u0010\tR\u0017\u0010L\u001a\b\u0012\u0004\u0012\u0002060\u00078F\u00a2\u0006\u0006\u001a\u0004\bM\u0010\tR\u0017\u0010N\u001a\b\u0012\u0004\u0012\u0002060\u00078F\u00a2\u0006\u0006\u001a\u0004\bO\u0010\tR\u0017\u0010P\u001a\b\u0012\u0004\u0012\u0002060\u00078F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010\tR\u0017\u0010R\u001a\b\u0012\u0004\u0012\u0002060\u00078F\u00a2\u0006\u0006\u001a\u0004\bS\u0010\tR\u0017\u0010T\u001a\b\u0012\u0004\u0012\u0002060\u00078F\u00a2\u0006\u0006\u001a\u0004\bU\u0010\tR\u0017\u0010V\u001a\b\u0012\u0004\u0012\u0002060\u00078F\u00a2\u0006\u0006\u001a\u0004\bW\u0010\tR\u0017\u0010X\u001a\b\u0012\u0004\u0012\u0002060\u00078F\u00a2\u0006\u0006\u001a\u0004\bY\u0010\tR\u0011\u0010Z\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\R\u0011\u0010]\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\b^\u0010\\R\u0011\u0010_\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\b`\u0010\\R\u0011\u0010a\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\bb\u0010\\R\u0011\u0010c\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\bd\u0010\\R\u0011\u0010e\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\bf\u0010\\R\u0011\u0010g\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\bh\u0010\\R\u0011\u0010i\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\bj\u0010\\R\u0011\u0010k\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\bl\u0010\\R\u0011\u0010m\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\bn\u0010\\R\u0011\u0010o\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\bp\u0010\\R\u0011\u0010q\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\br\u0010\\R\u0011\u0010s\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\bt\u0010\\R\u0011\u0010u\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\bv\u0010\\R\u0011\u0010w\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\bx\u0010\\R\u0011\u0010y\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\bz\u0010\\R\u0011\u0010{\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\b|\u0010\\R\u0011\u0010}\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\b~\u0010\\R\u0012\u0010\u007f\u001a\u0002098F\u00a2\u0006\u0007\u001a\u0005\b\u0080\u0001\u0010\\R\u0013\u0010\u0081\u0001\u001a\u0002098F\u00a2\u0006\u0007\u001a\u0005\b\u0082\u0001\u0010\\\u00a8\u0006\u0096\u0001"}, d2={"Lorg/springframework/cloud/contract/spec/internal/RequestDsl;", "Lorg/springframework/cloud/contract/spec/internal/CommonDsl;", "<init>", "()V", "delegate", "Lorg/springframework/cloud/contract/spec/internal/Request;", "method", "Lorg/springframework/cloud/contract/spec/internal/DslProperty;", "getMethod", "()Lorg/springframework/cloud/contract/spec/internal/DslProperty;", "setMethod", "(Lorg/springframework/cloud/contract/spec/internal/DslProperty;)V", "url", "Lorg/springframework/cloud/contract/spec/internal/Url;", "getUrl", "()Lorg/springframework/cloud/contract/spec/internal/Url;", "setUrl", "(Lorg/springframework/cloud/contract/spec/internal/Url;)V", "urlPath", "Lorg/springframework/cloud/contract/spec/internal/UrlPath;", "getUrlPath", "()Lorg/springframework/cloud/contract/spec/internal/UrlPath;", "setUrlPath", "(Lorg/springframework/cloud/contract/spec/internal/UrlPath;)V", "headers", "Lorg/springframework/cloud/contract/spec/internal/Headers;", "getHeaders", "()Lorg/springframework/cloud/contract/spec/internal/Headers;", "setHeaders", "(Lorg/springframework/cloud/contract/spec/internal/Headers;)V", "cookies", "Lorg/springframework/cloud/contract/spec/internal/Cookies;", "getCookies", "()Lorg/springframework/cloud/contract/spec/internal/Cookies;", "setCookies", "(Lorg/springframework/cloud/contract/spec/internal/Cookies;)V", "body", "Lorg/springframework/cloud/contract/spec/internal/Body;", "getBody", "()Lorg/springframework/cloud/contract/spec/internal/Body;", "setBody", "(Lorg/springframework/cloud/contract/spec/internal/Body;)V", "multipart", "Lorg/springframework/cloud/contract/spec/internal/Multipart;", "getMultipart", "()Lorg/springframework/cloud/contract/spec/internal/Multipart;", "setMultipart", "(Lorg/springframework/cloud/contract/spec/internal/Multipart;)V", "bodyMatchers", "Lorg/springframework/cloud/contract/spec/internal/BodyMatchers;", "getBodyMatchers", "()Lorg/springframework/cloud/contract/spec/internal/BodyMatchers;", "setBodyMatchers", "(Lorg/springframework/cloud/contract/spec/internal/BodyMatchers;)V", "", "", "client", "Lorg/springframework/cloud/contract/spec/internal/ClientDslProperty;", "server", "Lorg/springframework/cloud/contract/spec/internal/ServerDslProperty;", "path", "", "Lkotlin/Function1;", "Lorg/springframework/cloud/contract/spec/internal/HeadersDsl;", "Lkotlin/ExtensionFunctionType;", "Lorg/springframework/cloud/contract/spec/internal/CookiesDsl;", "", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)Lorg/springframework/cloud/contract/spec/internal/Body;", "", "configurer", "Lorg/springframework/cloud/contract/spec/internal/MultipartDsl;", "Lorg/springframework/cloud/contract/spec/internal/BodyMatchersDsl;", "GET", "getGET", "HEAD", "getHEAD", "POST", "getPOST", "PUT", "getPUT", "PATCH", "getPATCH", "DELETE", "getDELETE", "OPTIONS", "getOPTIONS", "TRACE", "getTRACE", "anyAlphaUnicode", "getAnyAlphaUnicode", "()Lorg/springframework/cloud/contract/spec/internal/ClientDslProperty;", "anyAlphaNumeric", "getAnyAlphaNumeric", "anyNumber", "getAnyNumber", "anyInteger", "getAnyInteger", "anyPositiveInt", "getAnyPositiveInt", "anyDouble", "getAnyDouble", "anyHex", "getAnyHex", "aBoolean", "getABoolean", "anyIpAddress", "getAnyIpAddress", "anyHostname", "getAnyHostname", "anyEmail", "getAnyEmail", "anyUrl", "getAnyUrl", "anyHttpsUrl", "getAnyHttpsUrl", "anyUuid", "getAnyUuid", "anyDate", "getAnyDate", "anyDateTime", "getAnyDateTime", "anyTime", "getAnyTime", "anyIso8601WithOffset", "getAnyIso8601WithOffset", "anyNonBlankString", "getAnyNonBlankString", "anyNonEmptyString", "getAnyNonEmptyString", "equalTo", "Lorg/springframework/cloud/contract/spec/internal/MatchingStrategy;", "value", "containing", "matching", "notMatching", "equalToXml", "equalToJson", "absent", "v", "Ljava/util/regex/Pattern;", "Lorg/springframework/cloud/contract/spec/internal/RegexProperty;", "anyOf", "values", "([Ljava/lang/String;)Lorg/springframework/cloud/contract/spec/internal/ClientDslProperty;", "get", "get$spring_cloud_contract_spec_kotlin", "RequestHeadersDsl", "RequestCookiesDsl", "spring-cloud-contract-spec-kotlin"})
@SourceDebugExtension(value={"SMAP\nRequestDsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestDsl.kt\norg/springframework/cloud/contract/spec/internal/RequestDsl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,331:1\n1#2:332\n*E\n"})
public class RequestDsl
extends CommonDsl {
    @NotNull
    private final Request delegate = new Request();
    @Nullable
    private DslProperty<?> method;
    @Nullable
    private Url url;
    @Nullable
    private UrlPath urlPath;
    @Nullable
    private Headers headers;
    @Nullable
    private Cookies cookies;
    @Nullable
    private Body body;
    @Nullable
    private Multipart multipart;
    @Nullable
    private BodyMatchers bodyMatchers;

    @Nullable
    public final DslProperty<?> getMethod() {
        return this.method;
    }

    public final void setMethod(@Nullable DslProperty<?> dslProperty) {
        this.method = dslProperty;
    }

    @Nullable
    public final Url getUrl() {
        return this.url;
    }

    public final void setUrl(@Nullable Url url) {
        this.url = url;
    }

    @Nullable
    public final UrlPath getUrlPath() {
        return this.urlPath;
    }

    public final void setUrlPath(@Nullable UrlPath urlPath) {
        this.urlPath = urlPath;
    }

    @Nullable
    public final Headers getHeaders() {
        return this.headers;
    }

    public final void setHeaders(@Nullable Headers headers) {
        this.headers = headers;
    }

    @Nullable
    public final Cookies getCookies() {
        return this.cookies;
    }

    public final void setCookies(@Nullable Cookies cookies) {
        this.cookies = cookies;
    }

    @Nullable
    public final Body getBody() {
        return this.body;
    }

    public final void setBody(@Nullable Body body) {
        this.body = body;
    }

    @Nullable
    public final Multipart getMultipart() {
        return this.multipart;
    }

    public final void setMultipart(@Nullable Multipart multipart) {
        this.multipart = multipart;
    }

    @Nullable
    public final BodyMatchers getBodyMatchers() {
        return this.bodyMatchers;
    }

    public final void setBodyMatchers(@Nullable BodyMatchers bodyMatchers) {
        this.bodyMatchers = bodyMatchers;
    }

    @NotNull
    public final DslProperty<String> method(@NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return ContractDslExtensionsKt.toDslProperty(method);
    }

    @NotNull
    public final Url url(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new Url((Object)url);
    }

    @NotNull
    public final Url url(@NotNull DslProperty<Object> url) {
        Intrinsics.checkNotNullParameter(url, (String)"url");
        return new Url(url);
    }

    @NotNull
    public final Url url(@NotNull ClientDslProperty client, @NotNull ServerDslProperty server) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return new Url(this.value(client, server));
    }

    @NotNull
    public final UrlPath path(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new UrlPath(path);
    }

    @NotNull
    public final UrlPath path(@NotNull DslProperty<Object> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return new UrlPath(path);
    }

    public final void headers(@NotNull Function1<? super HeadersDsl, Unit> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        RequestHeadersDsl requestHeadersDsl = new RequestHeadersDsl();
        headers.invoke((Object)requestHeadersDsl);
        this.headers = requestHeadersDsl.get$spring_cloud_contract_spec_kotlin();
    }

    public final void cookies(@NotNull Function1<? super CookiesDsl, Unit> cookies) {
        Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
        RequestCookiesDsl requestCookiesDsl = new RequestCookiesDsl();
        cookies.invoke((Object)requestCookiesDsl);
        this.cookies = requestCookiesDsl.get$spring_cloud_contract_spec_kotlin();
    }

    @NotNull
    public final Body body(@NotNull Map<String, ? extends Object> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(body));
    }

    @NotNull
    public final Body body(Pair<String, ? extends Object> ... body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(MapsKt.toMap(body)));
    }

    @NotNull
    public final Body body(@NotNull Pair<String, ? extends Object> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(MapsKt.mapOf(body)));
    }

    @NotNull
    public final Body body(@NotNull List<? extends Object> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(body));
    }

    @NotNull
    public final Body body(@NotNull Object body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return new Body(body);
    }

    public final void multipart(@NotNull Function1<? super MultipartDsl, Unit> configurer) {
        Intrinsics.checkNotNullParameter(configurer, (String)"configurer");
        MultipartDsl multipartDsl = new MultipartDsl();
        configurer.invoke((Object)multipartDsl);
        this.multipart = multipartDsl.get$spring_cloud_contract_spec_kotlin();
    }

    public final void bodyMatchers(@NotNull Function1<? super BodyMatchersDsl, Unit> configurer) {
        Intrinsics.checkNotNullParameter(configurer, (String)"configurer");
        BodyMatchersDsl bodyMatchersDsl = new BodyMatchersDsl();
        configurer.invoke((Object)bodyMatchersDsl);
        this.bodyMatchers = bodyMatchersDsl.get$spring_cloud_contract_spec_kotlin();
    }

    @NotNull
    public final DslProperty<String> getGET() {
        String string = HttpMethods.GET;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GET");
        return this.method(string);
    }

    @NotNull
    public final DslProperty<String> getHEAD() {
        String string = HttpMethods.HEAD;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HEAD");
        return this.method(string);
    }

    @NotNull
    public final DslProperty<String> getPOST() {
        String string = HttpMethods.POST;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"POST");
        return this.method(string);
    }

    @NotNull
    public final DslProperty<String> getPUT() {
        String string = HttpMethods.PUT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PUT");
        return this.method(string);
    }

    @NotNull
    public final DslProperty<String> getPATCH() {
        String string = HttpMethods.PATCH;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PATCH");
        return this.method(string);
    }

    @NotNull
    public final DslProperty<String> getDELETE() {
        String string = HttpMethods.DELETE;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DELETE");
        return this.method(string);
    }

    @NotNull
    public final DslProperty<String> getOPTIONS() {
        String string = HttpMethods.OPTIONS;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"OPTIONS");
        return this.method(string);
    }

    @NotNull
    public final DslProperty<String> getTRACE() {
        String string = HttpMethods.TRACE;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TRACE");
        return this.method(string);
    }

    @NotNull
    public final ClientDslProperty getAnyAlphaUnicode() {
        ClientDslProperty clientDslProperty = this.delegate.anyAlphaUnicode();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyAlphaUnicode(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyAlphaNumeric() {
        ClientDslProperty clientDslProperty = this.delegate.anyAlphaNumeric();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyAlphaNumeric(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyNumber() {
        ClientDslProperty clientDslProperty = this.delegate.anyNumber();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyNumber(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyInteger() {
        ClientDslProperty clientDslProperty = this.delegate.anyInteger();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyInteger(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyPositiveInt() {
        ClientDslProperty clientDslProperty = this.delegate.anyPositiveInt();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyPositiveInt(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyDouble() {
        ClientDslProperty clientDslProperty = this.delegate.anyDouble();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyDouble(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyHex() {
        ClientDslProperty clientDslProperty = this.delegate.anyHex();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyHex(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getABoolean() {
        ClientDslProperty clientDslProperty = this.delegate.aBoolean();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"aBoolean(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyIpAddress() {
        ClientDslProperty clientDslProperty = this.delegate.anyIpAddress();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyIpAddress(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyHostname() {
        ClientDslProperty clientDslProperty = this.delegate.anyHostname();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyHostname(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyEmail() {
        ClientDslProperty clientDslProperty = this.delegate.anyEmail();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyEmail(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyUrl() {
        ClientDslProperty clientDslProperty = this.delegate.anyUrl();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyUrl(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyHttpsUrl() {
        ClientDslProperty clientDslProperty = this.delegate.anyHttpsUrl();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyHttpsUrl(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyUuid() {
        ClientDslProperty clientDslProperty = this.delegate.anyUuid();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyUuid(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyDate() {
        ClientDslProperty clientDslProperty = this.delegate.anyDate();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyDate(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyDateTime() {
        ClientDslProperty clientDslProperty = this.delegate.anyDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyDateTime(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyTime() {
        ClientDslProperty clientDslProperty = this.delegate.anyTime();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyTime(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyIso8601WithOffset() {
        ClientDslProperty clientDslProperty = this.delegate.anyIso8601WithOffset();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyIso8601WithOffset(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyNonBlankString() {
        ClientDslProperty clientDslProperty = this.delegate.anyNonBlankString();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyNonBlankString(...)");
        return clientDslProperty;
    }

    @NotNull
    public final ClientDslProperty getAnyNonEmptyString() {
        ClientDslProperty clientDslProperty = this.delegate.anyNonEmptyString();
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyNonEmptyString(...)");
        return clientDslProperty;
    }

    @NotNull
    public final MatchingStrategy equalTo(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new MatchingStrategy(value, MatchingStrategy.Type.EQUAL_TO);
    }

    @NotNull
    public final MatchingStrategy containing(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new MatchingStrategy(value, MatchingStrategy.Type.CONTAINS);
    }

    @NotNull
    public final MatchingStrategy matching(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new MatchingStrategy(value, MatchingStrategy.Type.MATCHING);
    }

    @NotNull
    public final MatchingStrategy notMatching(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new MatchingStrategy(value, MatchingStrategy.Type.NOT_MATCHING);
    }

    @NotNull
    public final MatchingStrategy equalToXml(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new MatchingStrategy(value, MatchingStrategy.Type.EQUAL_TO_XML);
    }

    @NotNull
    public final MatchingStrategy equalToJson(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new MatchingStrategy(value, MatchingStrategy.Type.EQUAL_TO_JSON);
    }

    @NotNull
    public final MatchingStrategy absent() {
        return new MatchingStrategy((Object)true, MatchingStrategy.Type.ABSENT);
    }

    @NotNull
    public final DslProperty<Object> value(@NotNull ClientDslProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"value(...)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> v(@NotNull ClientDslProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"value(...)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> value(@NotNull DslProperty<Object> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"value(...)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> v(@NotNull DslProperty<Object> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"value(...)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> value(@NotNull Pattern value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"value(...)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> v(@NotNull Pattern value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"value(...)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> value(@NotNull RegexProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"value(...)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> v(@NotNull RegexProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"value(...)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> value(@Nullable Object value) {
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"value(...)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> v(@Nullable Object value) {
        DslProperty dslProperty = this.delegate.value(value);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"value(...)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> value(@NotNull ClientDslProperty client, @NotNull ServerDslProperty server) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        DslProperty dslProperty = this.delegate.value(client, server);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"value(...)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> v(@NotNull ClientDslProperty client, @NotNull ServerDslProperty server) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        DslProperty dslProperty = this.delegate.value(client, server);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"value(...)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> value(@NotNull ServerDslProperty server, @NotNull ClientDslProperty client) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        DslProperty dslProperty = this.delegate.value(client, server);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"value(...)");
        return dslProperty;
    }

    @NotNull
    public final DslProperty<Object> v(@NotNull ServerDslProperty server, @NotNull ClientDslProperty client) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        DslProperty dslProperty = this.delegate.value(client, server);
        Intrinsics.checkNotNullExpressionValue((Object)dslProperty, (String)"value(...)");
        return dslProperty;
    }

    @NotNull
    public final ClientDslProperty anyOf(String ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        ClientDslProperty clientDslProperty = this.delegate.anyOf(Arrays.copyOf(values, values.length));
        Intrinsics.checkNotNullExpressionValue((Object)clientDslProperty, (String)"anyOf(...)");
        return clientDslProperty;
    }

    @NotNull
    public final Request get$spring_cloud_contract_spec_kotlin() {
        Request request;
        block7: {
            Url it;
            Url url;
            request = new Request();
            Url url2 = this.method;
            if (url2 != null) {
                it = url = url2;
                boolean bl = false;
                request.setMethod(this.method);
            }
            Url url3 = this.url;
            if (url3 != null) {
                it = url = url3;
                boolean bl = false;
                request.setUrl(this.url);
            }
            UrlPath urlPath = this.urlPath;
            if (urlPath != null) {
                it = url = urlPath;
                boolean bl = false;
                request.setUrlPath(this.urlPath);
            }
            Headers headers = this.headers;
            if (headers != null) {
                it = url = headers;
                boolean bl = false;
                request.setHeaders(this.headers);
            }
            Cookies cookies = this.cookies;
            if (cookies != null) {
                it = url = cookies;
                boolean bl = false;
                request.setCookies(this.cookies);
            }
            Body body = this.body;
            if (body != null) {
                it = url = body;
                boolean bl = false;
                request.setBody(this.body);
            }
            Multipart multipart = this.multipart;
            if (multipart != null) {
                it = url = multipart;
                boolean bl = false;
                request.setMultipart(this.multipart);
            }
            BodyMatchers bodyMatchers = this.bodyMatchers;
            if (bodyMatchers == null) break block7;
            it = url = bodyMatchers;
            boolean bl = false;
            request.setBodyMatchers(this.bodyMatchers);
        }
        return request;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/springframework/cloud/contract/spec/internal/RequestDsl$RequestCookiesDsl;", "Lorg/springframework/cloud/contract/spec/internal/CookiesDsl;", "<init>", "()V", "common", "Lorg/springframework/cloud/contract/spec/internal/Common;", "matching", "", "value", "spring-cloud-contract-spec-kotlin"})
    private static final class RequestCookiesDsl
    extends CookiesDsl {
        @NotNull
        private final Common common = new Common();

        @Override
        @Nullable
        public Object matching(@Nullable Object value) {
            if (value != null) {
                Object it = value;
                boolean bl = false;
                return value instanceof String ? this.common.value(this.c(this.regex(RegexpUtils.escapeSpecialRegexWithSingleEscape((String)((String)value)) + ".*")), this.p(value)) : value;
            }
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/springframework/cloud/contract/spec/internal/RequestDsl$RequestHeadersDsl;", "Lorg/springframework/cloud/contract/spec/internal/HeadersDsl;", "<init>", "()V", "common", "Lorg/springframework/cloud/contract/spec/internal/Common;", "matching", "", "value", "spring-cloud-contract-spec-kotlin"})
    private static final class RequestHeadersDsl
    extends HeadersDsl {
        @NotNull
        private final Common common = new Common();

        @Override
        @Nullable
        public Object matching(@Nullable Object value) {
            if (value != null) {
                Object it = value;
                boolean bl = false;
                return value instanceof String ? this.common.value(this.c(this.regex(RegexpUtils.escapeSpecialRegexWithSingleEscape((String)((String)value)) + ".*")), this.p(value)) : value;
            }
            return null;
        }
    }
}

