/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.io.File;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.cloud.contract.spec.internal.Body;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.spec.internal.NamedProperty;
import org.springframework.cloud.contract.spec.internal.OptionalProperty;
import org.springframework.cloud.contract.spec.internal.RegexPatterns;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.spec.internal.ServerDslProperty;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b'\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u0016\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u0010\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0001J\u0010\u00105\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0001J\u0010\u00106\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0001J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020.J\u000e\u0010:\u001a\u00020;2\u0006\u0010-\u001a\u00020.J\u0016\u0010:\u001a\u00020;2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u000e\u0010<\u001a\u00020;2\u0006\u0010-\u001a\u00020.J\u0010\u0010=\u001a\u00020>2\u0006\u0010-\u001a\u00020.H\u0002J \u0010?\u001a\u00020@2\u0018\u0010A\u001a\u0014\u0012\u0004\u0012\u00020.\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010C0BJ\"\u0010?\u001a\u00020@2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00010C2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00010CJ0\u0010?\u001a\u00020@2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00010C2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00010C2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00010CJ\u0010\u0010G\u001a\u00020H2\b\u0010E\u001a\u0004\u0018\u00010\u0001J\u0010\u0010I\u001a\u00020J2\b\u0010K\u001a\u0004\u0018\u00010\u0001J\u0010\u0010L\u001a\u00020J2\b\u0010K\u001a\u0004\u0018\u00010\u0001J\u000e\u0010M\u001a\u00020\u00042\u0006\u0010M\u001a\u00020NJ\u000e\u0010M\u001a\u00020\u00042\u0006\u0010M\u001a\u00020.J\u000e\u0010M\u001a\u00020\u00042\u0006\u0010M\u001a\u00020\u0004J\u000e\u0010O\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\u0001J\u0010\u0010P\u001a\u00020J2\b\u0010K\u001a\u0004\u0018\u00010\u0001J\u0010\u0010Q\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0001J\u0010\u0010R\u001a\u00020J2\b\u0010K\u001a\u0004\u0018\u00010\u0001R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0006R\u0011\u0010%\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0006R\u0011\u0010'\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0006R\u0011\u0010)\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0006\u00a8\u0006S"}, d2={"Lorg/springframework/cloud/contract/spec/internal/CommonDsl;", "", "()V", "aDouble", "Lorg/springframework/cloud/contract/spec/internal/RegexProperty;", "getADouble", "()Lorg/springframework/cloud/contract/spec/internal/RegexProperty;", "alphaNumeric", "getAlphaNumeric", "anHttpsUrl", "getAnHttpsUrl", "anInteger", "getAnInteger", "anUrl", "getAnUrl", "anyBoolean", "getAnyBoolean", "email", "getEmail", "hostname", "getHostname", "ipAddress", "getIpAddress", "iso8601WithOffset", "getIso8601WithOffset", "isoDate", "getIsoDate", "isoDateTime", "getIsoDateTime", "isoTime", "getIsoTime", "nonBlank", "getNonBlank", "nonEmpty", "getNonEmpty", "number", "getNumber", "onlyAlphaUnicode", "getOnlyAlphaUnicode", "positiveInt", "getPositiveInt", "uuid", "getUuid", "bodyFromFile", "Lorg/springframework/cloud/contract/spec/internal/Body;", "relativePath", "", "charset", "Ljava/nio/charset/Charset;", "bodyFromFileAsBytes", "c", "Lorg/springframework/cloud/contract/spec/internal/ClientDslProperty;", "clientValue", "client", "consumer", "execute", "Lorg/springframework/cloud/contract/spec/internal/ExecutionProperty;", "commandToExecute", "file", "Lorg/springframework/cloud/contract/spec/internal/FromFileProperty;", "fileAsBytes", "fileLocation", "Ljava/io/File;", "named", "Lorg/springframework/cloud/contract/spec/internal/NamedProperty;", "namedMap", "", "Lorg/springframework/cloud/contract/spec/internal/DslProperty;", "name", "value", "contentType", "optional", "Lorg/springframework/cloud/contract/spec/internal/OptionalProperty;", "p", "Lorg/springframework/cloud/contract/spec/internal/ServerDslProperty;", "serverValue", "producer", "regex", "Ljava/util/regex/Pattern;", "regexProperty", "server", "stub", "test", "spring-cloud-contract-spec-kotlin"})
public class CommonDsl {
    @NotNull
    public final RegexProperty getOnlyAlphaUnicode() {
        RegexProperty regexProperty = RegexPatterns.onlyAlphaUnicode();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"onlyAlphaUnicode()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getAlphaNumeric() {
        RegexProperty regexProperty = RegexPatterns.alphaNumeric();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"alphaNumeric()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getNumber() {
        RegexProperty regexProperty = RegexPatterns.number();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"number()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getPositiveInt() {
        RegexProperty regexProperty = RegexPatterns.positiveInt();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"positiveInt()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getAnyBoolean() {
        RegexProperty regexProperty = RegexPatterns.anyBoolean();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"anyBoolean()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getAnInteger() {
        RegexProperty regexProperty = RegexPatterns.anInteger();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"anInteger()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getADouble() {
        RegexProperty regexProperty = RegexPatterns.aDouble();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"aDouble()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getIpAddress() {
        RegexProperty regexProperty = RegexPatterns.ipAddress();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"ipAddress()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getHostname() {
        RegexProperty regexProperty = RegexPatterns.hostname();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"hostname()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getEmail() {
        RegexProperty regexProperty = RegexPatterns.email();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"email()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getAnUrl() {
        RegexProperty regexProperty = RegexPatterns.url();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"url()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getAnHttpsUrl() {
        RegexProperty regexProperty = RegexPatterns.httpsUrl();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"httpsUrl()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getUuid() {
        RegexProperty regexProperty = RegexPatterns.uuid();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"uuid()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getIsoDate() {
        RegexProperty regexProperty = RegexPatterns.isoDate();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"isoDate()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getIsoDateTime() {
        RegexProperty regexProperty = RegexPatterns.isoDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"isoDateTime()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getIsoTime() {
        RegexProperty regexProperty = RegexPatterns.isoTime();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"isoTime()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getIso8601WithOffset() {
        RegexProperty regexProperty = RegexPatterns.iso8601WithOffset();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"iso8601WithOffset()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getNonEmpty() {
        RegexProperty regexProperty = RegexPatterns.nonEmpty();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"nonEmpty()");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getNonBlank() {
        RegexProperty regexProperty = RegexPatterns.nonBlank();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"nonBlank()");
        return regexProperty;
    }

    @NotNull
    public final ClientDslProperty client(@Nullable Object clientValue) {
        return new ClientDslProperty(clientValue);
    }

    @NotNull
    public final ClientDslProperty c(@Nullable Object clientValue) {
        return new ClientDslProperty(clientValue);
    }

    @NotNull
    public final ClientDslProperty consumer(@Nullable Object clientValue) {
        return new ClientDslProperty(clientValue);
    }

    @NotNull
    public final ClientDslProperty stub(@Nullable Object clientValue) {
        return new ClientDslProperty(clientValue);
    }

    @NotNull
    public final ServerDslProperty server(@Nullable Object serverValue) {
        return new ServerDslProperty(serverValue);
    }

    @NotNull
    public final ServerDslProperty p(@Nullable Object serverValue) {
        return new ServerDslProperty(serverValue);
    }

    @NotNull
    public final ServerDslProperty producer(@Nullable Object serverValue) {
        return new ServerDslProperty(serverValue);
    }

    @NotNull
    public final ServerDslProperty test(@Nullable Object serverValue) {
        return new ServerDslProperty(serverValue);
    }

    @NotNull
    public final OptionalProperty optional(@Nullable Object value) {
        return new OptionalProperty(value);
    }

    @NotNull
    public final ExecutionProperty execute(@NotNull String commandToExecute) {
        Intrinsics.checkNotNullParameter((Object)commandToExecute, (String)"commandToExecute");
        return new ExecutionProperty(commandToExecute);
    }

    @NotNull
    public final FromFileProperty file(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
        return this.file(relativePath, charset);
    }

    @NotNull
    public final FromFileProperty file(@NotNull String relativePath, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return new FromFileProperty(this.fileLocation(relativePath), String.class, charset);
    }

    @NotNull
    public final FromFileProperty fileAsBytes(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return new FromFileProperty(this.fileLocation(relativePath), byte[].class);
    }

    @NotNull
    public final Body bodyFromFile(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
        return this.bodyFromFile(relativePath, charset);
    }

    @NotNull
    public final Body bodyFromFile(@NotNull String relativePath, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return new Body((Serializable)new FromFileProperty(this.fileLocation(relativePath), String.class, charset));
    }

    @NotNull
    public final Body bodyFromFileAsBytes(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return new Body((Serializable)new FromFileProperty(this.fileLocation(relativePath), byte[].class));
    }

    private final File fileLocation(String relativePath) {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(relativePath);
        if (uRL == null) {
            throw new IllegalStateException("File [" + relativePath + "] is not present");
        }
        URL resource = uRL;
        try {
            return new File(resource.toURI());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @NotNull
    public final NamedProperty named(@NotNull DslProperty<Object> name, @NotNull DslProperty<Object> value) {
        Intrinsics.checkNotNullParameter(name, (String)"name");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return new NamedProperty(name, value);
    }

    @NotNull
    public final NamedProperty named(@NotNull DslProperty<Object> name, @NotNull DslProperty<Object> value, @NotNull DslProperty<Object> contentType) {
        Intrinsics.checkNotNullParameter(name, (String)"name");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(contentType, (String)"contentType");
        return new NamedProperty(name, value, contentType);
    }

    @NotNull
    public final NamedProperty named(@NotNull Map<String, ? extends DslProperty<Object>> namedMap) {
        Intrinsics.checkNotNullParameter(namedMap, (String)"namedMap");
        return new NamedProperty(namedMap);
    }

    @NotNull
    public final RegexProperty regexProperty(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new RegexProperty(value);
    }

    @NotNull
    public final RegexProperty regex(@NotNull String regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Pattern pattern = Pattern.compile(regex);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(regex)");
        return this.regexProperty(pattern);
    }

    @NotNull
    public final RegexProperty regex(@NotNull Pattern regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return this.regexProperty(regex);
    }

    @NotNull
    public final RegexProperty regex(@NotNull RegexProperty regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return regex;
    }
}

