/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.BodyMatchersDsl$sam$java_util_function_BiConsumer$0;
import org.springframework.cloud.contract.spec.internal.MatchingType;
import org.springframework.cloud.contract.spec.internal.MatchingTypeValue;
import org.springframework.cloud.contract.spec.internal.MatchingTypeValueHolder;
import org.springframework.cloud.contract.spec.internal.RegexMatchingTypeValue;
import org.springframework.cloud.contract.spec.internal.RegexPatterns;
import org.springframework.cloud.contract.spec.internal.RegexProperty;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0016J\u001f\u0010\u0017\u001a\u00020\u00042\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019\u00a2\u0006\u0002\b\u001cJ!\u0010\u001d\u001a\u0002H\u001e\"\b\b\u0000\u0010\u001e*\u00020\u001f2\u0006\u0010 \u001a\u0002H\u001eH\u0000\u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\u001fH\u0010\u00a2\u0006\u0002\b$J\u0016\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u0004J\u0016\u0010(\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0004`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0004`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/springframework/cloud/contract/spec/internal/BodyMatchersDsl;", "", "()V", "byDate", "Lorg/springframework/cloud/contract/spec/internal/MatchingTypeValue;", "getByDate", "()Lorg/springframework/cloud/contract/spec/internal/MatchingTypeValue;", "byEquality", "getByEquality", "byTime", "getByTime", "byTimestamp", "getByTimestamp", "jsonPathMatchers", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "xPathMatchers", "byRegex", "Lorg/springframework/cloud/contract/spec/internal/RegexMatchingTypeValue;", "regex", "Ljava/util/regex/Pattern;", "Lorg/springframework/cloud/contract/spec/internal/RegexProperty;", "byType", "configurer", "Lkotlin/Function1;", "Lorg/springframework/cloud/contract/spec/internal/MatchingTypeValueHolder;", "", "Lkotlin/ExtensionFunctionType;", "configureBodyMatchers", "T", "Lorg/springframework/cloud/contract/spec/internal/BodyMatchers;", "bodyMatchers", "configureBodyMatchers$spring_cloud_contract_spec_kotlin", "(Lorg/springframework/cloud/contract/spec/internal/BodyMatchers;)Lorg/springframework/cloud/contract/spec/internal/BodyMatchers;", "get", "get$spring_cloud_contract_spec_kotlin", "jsonPath", "path", "matcher", "xPath", "spring-cloud-contract-spec-kotlin"})
public class BodyMatchersDsl {
    private final LinkedHashMap<String, MatchingTypeValue> jsonPathMatchers = new LinkedHashMap();
    private final LinkedHashMap<String, MatchingTypeValue> xPathMatchers = new LinkedHashMap();

    public final void jsonPath(@NotNull String path, @NotNull MatchingTypeValue matcher) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        ((Map)this.jsonPathMatchers).put(path, matcher);
    }

    public final void xPath(@NotNull String path, @NotNull MatchingTypeValue matcher) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        ((Map)this.xPathMatchers).put(path, matcher);
    }

    @NotNull
    public final MatchingTypeValue getByDate() {
        return new MatchingTypeValue(MatchingType.DATE, (Object)RegexPatterns.isoDate());
    }

    @NotNull
    public final MatchingTypeValue getByTime() {
        return new MatchingTypeValue(MatchingType.TIME, (Object)RegexPatterns.isoTime());
    }

    @NotNull
    public final MatchingTypeValue getByTimestamp() {
        return new MatchingTypeValue(MatchingType.TIMESTAMP, (Object)RegexPatterns.isoDateTime());
    }

    @NotNull
    public final MatchingTypeValue getByEquality() {
        return new MatchingTypeValue(MatchingType.EQUALITY);
    }

    @NotNull
    public final RegexMatchingTypeValue byRegex(@NotNull String regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Pattern pattern = Pattern.compile(regex);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(regex)");
        return this.byRegex(pattern);
    }

    @NotNull
    public final RegexMatchingTypeValue byRegex(@NotNull RegexProperty regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return new RegexMatchingTypeValue(MatchingType.REGEX, (Object)regex);
    }

    @NotNull
    public final RegexMatchingTypeValue byRegex(@NotNull Pattern regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return new RegexMatchingTypeValue(MatchingType.REGEX, (Object)new RegexProperty((Object)regex));
    }

    @NotNull
    public final MatchingTypeValue byType(@NotNull Function1<? super MatchingTypeValueHolder, Unit> configurer) {
        Intrinsics.checkNotNullParameter(configurer, (String)"configurer");
        MatchingTypeValueHolder matchingTypeValueHolder = new MatchingTypeValueHolder();
        boolean bl = false;
        boolean bl2 = false;
        configurer.invoke((Object)matchingTypeValueHolder);
        MatchingTypeValue matchingTypeValue = matchingTypeValueHolder.matchingTypeValue;
        Intrinsics.checkNotNullExpressionValue((Object)matchingTypeValue, (String)"MatchingTypeValueHolder(\u2026igurer).matchingTypeValue");
        return matchingTypeValue;
    }

    @NotNull
    public BodyMatchers get$spring_cloud_contract_spec_kotlin() {
        return this.configureBodyMatchers$spring_cloud_contract_spec_kotlin(new BodyMatchers());
    }

    @NotNull
    public final <T extends BodyMatchers> T configureBodyMatchers$spring_cloud_contract_spec_kotlin(@NotNull T bodyMatchers) {
        Intrinsics.checkNotNullParameter(bodyMatchers, (String)"bodyMatchers");
        Function2 function2 = (Function2)new Function2<String, MatchingTypeValue, Unit>(bodyMatchers){

            public final void invoke(String p1, MatchingTypeValue p2) {
                ((BodyMatchers)this.receiver).jsonPath(p1, p2);
            }
        };
        this.jsonPathMatchers.forEach(new BodyMatchersDsl$sam$java_util_function_BiConsumer$0(function2));
        function2 = (Function2)new Function2<String, MatchingTypeValue, Unit>(bodyMatchers){

            public final void invoke(String p1, MatchingTypeValue p2) {
                ((BodyMatchers)this.receiver).xPath(p1, p2);
            }
        };
        this.xPathMatchers.forEach(new BodyMatchersDsl$sam$java_util_function_BiConsumer$0(function2));
        return bodyMatchers;
    }
}

