/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.internal;

import java.util.Set;
import shaded.com.google.common.base.MoreObjects;
import shaded.com.google.common.base.Objects;
import shaded.com.google.common.collect.ImmutableSet;
import shaded.com.google.inject.Binder;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.Provider;
import shaded.com.google.inject.internal.BindingImpl;
import shaded.com.google.inject.internal.GuiceInternal;
import shaded.com.google.inject.internal.InjectorImpl;
import shaded.com.google.inject.internal.InternalFactory;
import shaded.com.google.inject.internal.Scoping;
import shaded.com.google.inject.spi.BindingTargetVisitor;
import shaded.com.google.inject.spi.Dependency;
import shaded.com.google.inject.spi.Elements;
import shaded.com.google.inject.spi.HasDependencies;
import shaded.com.google.inject.spi.InjectionPoint;
import shaded.com.google.inject.spi.ProviderInstanceBinding;
import shaded.com.google.inject.spi.ProviderWithExtensionVisitor;
import shaded.com.google.inject.util.Providers;

class ProviderInstanceBindingImpl<T>
extends BindingImpl<T>
implements ProviderInstanceBinding<T> {
    final javax.inject.Provider<? extends T> providerInstance;
    final ImmutableSet<InjectionPoint> injectionPoints;

    public ProviderInstanceBindingImpl(InjectorImpl injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory, Scoping scoping, javax.inject.Provider<? extends T> providerInstance, Set<InjectionPoint> injectionPoints) {
        super(injector, key, source, internalFactory, scoping);
        this.providerInstance = providerInstance;
        this.injectionPoints = ImmutableSet.copyOf(injectionPoints);
    }

    public ProviderInstanceBindingImpl(Object source, Key<T> key, Scoping scoping, Set<InjectionPoint> injectionPoints, javax.inject.Provider<? extends T> providerInstance) {
        super(source, key, scoping);
        this.injectionPoints = ImmutableSet.copyOf(injectionPoints);
        this.providerInstance = providerInstance;
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        if (this.providerInstance instanceof ProviderWithExtensionVisitor) {
            return ((ProviderWithExtensionVisitor)this.providerInstance).acceptExtensionVisitor(visitor, this);
        }
        return visitor.visit(this);
    }

    @Override
    public Provider<? extends T> getProviderInstance() {
        return Providers.guicify(this.providerInstance);
    }

    @Override
    public javax.inject.Provider<? extends T> getUserSuppliedProvider() {
        return this.providerInstance;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return this.providerInstance instanceof HasDependencies ? ImmutableSet.copyOf(((HasDependencies)this.providerInstance).getDependencies()) : Dependency.forInjectionPoints(this.injectionPoints);
    }

    @Override
    public BindingImpl<T> withScoping(Scoping scoping) {
        return new ProviderInstanceBindingImpl<T>(this.getSource(), this.getKey(), scoping, this.injectionPoints, this.providerInstance);
    }

    @Override
    public BindingImpl<T> withKey(Key<T> key) {
        return new ProviderInstanceBindingImpl<T>(this.getSource(), key, this.getScoping(), this.injectionPoints, this.providerInstance);
    }

    @Override
    public void applyTo(Binder binder) {
        this.getScoping().applyTo(Elements.withTrustedSource(GuiceInternal.GUICE_INTERNAL, binder, this.getSource()).bind(this.getKey()).toProvider(this.getUserSuppliedProvider()));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(ProviderInstanceBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("scope", this.getScoping()).add("provider", this.providerInstance).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProviderInstanceBindingImpl) {
            ProviderInstanceBindingImpl o = (ProviderInstanceBindingImpl)obj;
            return this.getKey().equals(o.getKey()) && this.getScoping().equals(o.getScoping()) && Objects.equal(this.providerInstance, o.providerInstance);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getKey(), this.getScoping());
    }
}

