/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package shaded.org.apache.maven.repository.internal;

import javax.inject.Named;
import javax.inject.Singleton;

import shaded.org.apache.maven.model.building.ModelCache;
import org.eclipse.aether.RepositorySystemSession;

/**
 * Default implementation of {@link ModelCacheFactory}.
 */
@Singleton
@Named
public class DefaultModelCacheFactory implements ModelCacheFactory {
    @Override
    public ModelCache createCache(RepositorySystemSession session) {
        return DefaultModelCache.newInstance(session);
    }
}
